/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.core.libfolders.LibraryFolderManager;
import org.eclipse.php.internal.ui.actions.UseAsLibraryFolderAction;
import org.eclipse.php.internal.ui.actions.UseAsSourceFolderAction;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class LibraryFolderActionGroup
extends CommonActionProvider {
    private IWorkbenchSite fSite;

    public LibraryFolderActionGroup() {
    }

    public LibraryFolderActionGroup(IViewPart part) {
        this.fSite = part.getSite();
    }

    public void init(ICommonActionExtensionSite site) {
        ICommonViewerWorkbenchSite workbenchSite = null;
        if (site.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            workbenchSite = (ICommonViewerWorkbenchSite)site.getViewSite();
        }
        if (workbenchSite != null && workbenchSite.getSite() != null) {
            this.fSite = workbenchSite.getSite();
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        IAction action = this.getActionFromSelection();
        if (action != null) {
            menu.appendToGroup("group.reorganize", action);
        }
    }

    private IAction getActionFromSelection() {
        ISelection sel = this.fSite.getSelectionProvider().getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        Iterator iterator = selection.iterator();
        HashSet<IFolder> selected = new HashSet<IFolder>();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof IModelElement)) {
                return null;
            }
            IModelElement element = (IModelElement)obj;
            IResource resource = element.getResource();
            if (resource == null) {
                return null;
            }
            if (resource.getType() != 2) {
                return null;
            }
            selected.add((IFolder)resource);
        }
        IFolder[] folders = selected.toArray(new IFolder[selected.size()]);
        if (folders.length == 0) {
            return null;
        }
        if (!this.allOfSameKind(folders)) {
            return null;
        }
        if (LibraryFolderManager.getInstance().isInLibraryFolder((IResource)folders[0])) {
            return new UseAsSourceFolderAction(this.fSite, folders);
        }
        return new UseAsLibraryFolderAction(folders);
    }

    private boolean allOfSameKind(IFolder[] folders) {
        int libraryFolderCount = 0;
        IFolder[] iFolderArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder folder = iFolderArray[n2];
            if (LibraryFolderManager.getInstance().isInLibraryFolder((IResource)folder)) {
                ++libraryFolderCount;
            }
            ++n2;
        }
        return libraryFolderCount == 0 || libraryFolderCount == folders.length;
    }
}

