/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ILocalVariable;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.dltk.ui.text.completion.ICompletionProposalLabelProviderExtension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.codeassist.AliasField;
import org.eclipse.php.internal.core.codeassist.AliasMethod;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.typeinference.FakeConstructor;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.PHPModelLabelProvider;

public class PHPCompletionProposalLabelProvider
extends CompletionProposalLabelProvider
implements ICompletionProposalLabelProviderExtension {
    private static final PHPModelLabelProvider fLabelProvider = new PHPModelLabelProvider();
    private static final String ENCLOSING_TYPE_SEPARATOR = String.valueOf('\\');

    protected String createMethodProposalLabel(CompletionProposal methodProposal) {
        return this.createStyledMethodProposalLabel(methodProposal).toString();
    }

    protected String createOverrideMethodProposalLabel(CompletionProposal methodProposal) {
        return this.createStyledOverrideMethodProposalLabel(methodProposal).toString();
    }

    protected StyledString createStyledOverrideMethodProposalLabel(CompletionProposal methodProposal) {
        IType type;
        StyledString nameBuffer = new StyledString();
        IMethod method = (IMethod)methodProposal.getModelElement();
        if (method instanceof FakeConstructor && (type = (IType)method.getParent()) instanceof AliasType) {
            AliasType aliasType = (AliasType)type;
            nameBuffer.append(aliasType.getAlias());
            nameBuffer.append("()");
            return nameBuffer;
        }
        boolean isAlias = method instanceof AliasMethod;
        if (isAlias) {
            AliasMethod aliasMethod = (AliasMethod)method;
            nameBuffer.append(aliasMethod.getAlias());
        } else {
            nameBuffer.append(method.getElementName());
        }
        nameBuffer.append('(');
        this.appendStyledParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        this.appendMethodType(nameBuffer, methodProposal);
        if (isAlias) {
            return nameBuffer;
        }
        nameBuffer.append(" - ", StyledString.DECORATIONS_STYLER);
        IModelElement parent = method.getParent();
        if (parent instanceof IType) {
            IType type2 = (IType)parent;
            nameBuffer.append(type2.getTypeQualifiedName(ENCLOSING_TYPE_SEPARATOR), StyledString.QUALIFIER_STYLER);
        } else {
            nameBuffer.append(parent.getElementName(), StyledString.QUALIFIER_STYLER);
        }
        return nameBuffer;
    }

    protected void appendMethodType(StyledString nameBuffer, CompletionProposal methodProposal) {
        if (this.showMethodReturnType()) {
            IMethod method = (IMethod)methodProposal.getModelElement();
            if (method instanceof AliasMethod) {
                method = (IMethod)((AliasMethod)method).getMethod();
            }
            if (method == null) {
                return;
            }
            try {
                if (method.isConstructor() || !method.exists()) {
                    return;
                }
                nameBuffer.append(this.getReturnTypeSeparator(), StyledString.DECORATIONS_STYLER);
                String type = method.getType();
                if (type == null) {
                    type = (method.getFlags() & 0x2000000) != 0 ? "mixed" : "void";
                }
                nameBuffer.append(type, StyledString.DECORATIONS_STYLER);
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
        }
    }

    private boolean showMethodReturnType() {
        return PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("methodreturntype");
    }

    public String createTypeProposalLabel(CompletionProposal typeProposal) {
        return this.createStyledTypeProposalLabel(typeProposal).toString();
    }

    protected String createLabelWithTypeAndDeclaration(CompletionProposal proposal) {
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(proposal.getName());
        IField field = (IField)proposal.getModelElement();
        if (field.getParent() != null) {
            nameBuffer.append(" - ");
            IModelElement parent = field.getParent();
            nameBuffer.append(parent.getElementName());
        }
        return nameBuffer.toString();
    }

    protected String createTypeProposalLabel(String fullName) {
        return super.createTypeProposalLabel(fullName);
    }

    public ImageDescriptor createImageDescriptor(CompletionProposal proposal) {
        if (proposal.getModelElement() instanceof ArchiveProjectFragment) {
            return DLTKPluginImages.DESC_OBJS_JAR;
        }
        ImageDescriptor imageDescriptor = fLabelProvider.getImageDescriptor(proposal.getModelElement(), 3);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createImageDescriptor(proposal);
    }

    public ImageDescriptor createTypeImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = fLabelProvider.getImageDescriptor(proposal.getModelElement(), 3);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createTypeImageDescriptor(proposal);
    }

    public String createFieldProposalLabel(CompletionProposal proposal) {
        return this.createStyledFieldProposalLabel(proposal).toString();
    }

    public ImageDescriptor createFieldImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = fLabelProvider.getImageDescriptor(proposal.getModelElement(), 3);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createFieldImageDescriptor(proposal);
    }

    public ImageDescriptor createMethodImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = fLabelProvider.getImageDescriptor(proposal.getModelElement(), 3);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createMethodImageDescriptor(proposal);
    }

    public StyledString createStyledFieldProposalLabel(CompletionProposal proposal) {
        StyledString buffer = new StyledString();
        if (proposal.getModelElement() instanceof AliasField) {
            AliasField aliasField = (AliasField)proposal.getModelElement();
            buffer.append(aliasField.getAlias());
            return buffer;
        }
        IModelElement element = proposal.getModelElement();
        if (element != null && element.getElementType() == 8) {
            IField field = (IField)element;
            try {
                String type = field.getType();
                if (type != null) {
                    buffer.append(proposal.getName());
                    buffer.append(this.getReturnTypeSeparator(), StyledString.DECORATIONS_STYLER);
                    buffer.append(type, StyledString.DECORATIONS_STYLER);
                    return buffer;
                }
            }
            catch (ModelException modelException) {}
        }
        buffer.append(proposal.getName());
        return buffer;
    }

    public StyledString createStyledLabel(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 5: 
            case 9: 
            case 10: {
                return this.createStyledMethodProposalLabel(proposal);
            }
            case 6: {
                return this.createStyledOverrideMethodProposalLabel(proposal);
            }
            case 7: {
                return this.createStyledTypeProposalLabel(proposal);
            }
            case 1: {
                return this.createStyledFieldProposalLabel(proposal);
            }
            case 4: 
            case 8: {
                return this.createStyledSimpleLabelWithType(proposal);
            }
            case 2: {
                return this.createStyledKeywordLabel(proposal);
            }
            case 3: 
            case 11: {
                return this.createStyledSimpleLabel(proposal);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    protected StyledString createStyledMethodProposalLabel(CompletionProposal methodProposal) {
        StyledString nameBuffer = new StyledString();
        boolean isAlias = methodProposal.getModelElement() instanceof AliasMethod;
        if (isAlias) {
            AliasMethod aliasMethod = (AliasMethod)methodProposal.getModelElement();
            nameBuffer.append(aliasMethod.getAlias());
        } else {
            nameBuffer.append(methodProposal.getName());
        }
        nameBuffer.append('(');
        this.appendStyledParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        this.appendMethodType(nameBuffer, methodProposal);
        if (isAlias) {
            return nameBuffer;
        }
        IMethod method = (IMethod)methodProposal.getModelElement();
        nameBuffer.append(" - ", StyledString.DECORATIONS_STYLER);
        IModelElement parent = method.getParent();
        if (parent instanceof IType) {
            IType type = (IType)parent;
            nameBuffer.append(type.getTypeQualifiedName(ENCLOSING_TYPE_SEPARATOR), StyledString.QUALIFIER_STYLER);
        } else {
            nameBuffer.append(parent.getElementName(), StyledString.QUALIFIER_STYLER);
        }
        return nameBuffer;
    }

    protected StyledString appendStyledParameterList(StyledString buffer, CompletionProposal methodProposal) {
        Integer paramLimit;
        String[] parameterNames = methodProposal.findParameterNames(null);
        IMethod method = (IMethod)methodProposal.getModelElement();
        if (method instanceof AliasMethod) {
            method = (IMethod)((AliasMethod)method).getMethod();
        }
        boolean isVariadic = false;
        try {
            if (method != null && PHPFlags.isVariadic((int)method.getFlags())) {
                isVariadic = true;
            }
        }
        catch (ModelException e) {
            Logger.logException(e);
        }
        String[] parameterTypes = null;
        if (parameterNames != null && (paramLimit = (Integer)methodProposal.getAttribute("org.eclipse.dltk.uiCompletionProposal#ParameterLimit")) != null) {
            int i = 0;
            while (i < parameterNames.length) {
                if (i >= paramLimit) break;
                if (i > 0) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                if (isVariadic && i + 1 == parameterNames.length) {
                    buffer.append("...");
                }
                buffer.append(parameterNames[i]);
                ++i;
            }
            return buffer;
        }
        return this.appendStyledParameterSignature(buffer, parameterTypes, parameterNames, isVariadic);
    }

    protected StyledString appendStyledParameterSignature(StyledString buffer, String[] parameterTypes, String[] parameterNames, boolean isVariadic) {
        if (parameterNames != null) {
            int i = 0;
            while (i < parameterNames.length) {
                if (i > 0) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                if (isVariadic && i + 1 == parameterNames.length) {
                    buffer.append("...");
                }
                buffer.append(parameterNames[i]);
                ++i;
            }
        }
        return buffer;
    }

    public String createLabel(CompletionProposal proposal) {
        return this.createStyledLabel(proposal).toString();
    }

    public StyledString createStyledKeywordLabel(CompletionProposal proposal) {
        return new StyledString(proposal.getName());
    }

    public StyledString createStyledSimpleLabel(CompletionProposal proposal) {
        return new StyledString(proposal.getName());
    }

    public StyledString createStyledTypeProposalLabel(CompletionProposal typeProposal) {
        StyledString nameBuffer = new StyledString();
        IType type = (IType)typeProposal.getModelElement();
        if (type instanceof AliasType) {
            AliasType aliasType = (AliasType)type;
            nameBuffer.append(aliasType.getAlias());
            return nameBuffer;
        }
        nameBuffer.append(typeProposal.getName());
        boolean isNamespace = false;
        try {
            isNamespace = PHPFlags.isNamespace((int)type.getFlags());
        }
        catch (ModelException e) {
            Logger.logException(e);
        }
        if (type.getParent() != null && !isNamespace) {
            nameBuffer.append(" - ", StyledString.DECORATIONS_STYLER);
            IModelElement parent = type.getParent();
            nameBuffer.append(parent.getElementName(), StyledString.QUALIFIER_STYLER);
        }
        return nameBuffer;
    }

    public StyledString createStyledSimpleLabelWithType(CompletionProposal proposal) {
        ILocalVariable var;
        String type;
        StyledString buffer = new StyledString(proposal.getName());
        IModelElement element = proposal.getModelElement();
        if (element != null && element.getElementType() == 13 && element.exists() && (type = (var = (ILocalVariable)element).getType()) != null) {
            buffer.append(this.getReturnTypeSeparator(), StyledString.DECORATIONS_STYLER);
            buffer.append(type, StyledString.QUALIFIER_STYLER);
        }
        return buffer;
    }

    protected String createSimpleLabelWithType(CompletionProposal proposal) {
        return this.createStyledSimpleLabelWithType(proposal).toString();
    }
}

