/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.selectionactions;

import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.visitor.ApplyAll;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.corext.dom.SelectionAnalyzer;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.selectionactions.Messages;
import org.eclipse.php.internal.ui.editor.selectionactions.SelectionHistory;
import org.eclipse.php.internal.ui.editor.selectionactions.StructureSelectionAction;

public class StructureSelectPreviousAction
extends StructureSelectionAction {
    public StructureSelectPreviousAction(PHPStructuredEditor editor, SelectionHistory history) {
        super(Messages.StructureSelectPreviousAction_3, editor, history);
        this.setToolTipText(Messages.StructureSelectPreviousAction_4);
        this.setDescription(Messages.StructureSelectPreviousAction_5);
    }

    public StructureSelectPreviousAction() {
    }

    @Override
    ISourceRange internalGetNewSelectionRange(ISourceRange oldSourceRange, ISourceReference sr, SelectionAnalyzer selAnalyzer) throws ModelException {
        ASTNode previousNode;
        if (oldSourceRange.getLength() == 0 && selAnalyzer.getLastCoveringNode() != null && (previousNode = PreviousNodeAnalyzer.perform(oldSourceRange.getOffset(), selAnalyzer.getLastCoveringNode())) != null) {
            return StructureSelectPreviousAction.getSelectedNodeSourceRange(sr, previousNode);
        }
        ASTNode first = selAnalyzer.getFirstSelectedNode();
        if (first == null) {
            return StructureSelectPreviousAction.getLastCoveringNodeRange(oldSourceRange, sr, selAnalyzer);
        }
        ASTNode parent = first.getParent();
        if (parent == null) {
            return StructureSelectPreviousAction.getLastCoveringNodeRange(oldSourceRange, sr, selAnalyzer);
        }
        ASTNode previousNode2 = StructureSelectPreviousAction.getPreviousNode(parent, selAnalyzer.getSelectedNodes()[0]);
        if (previousNode2 == parent) {
            return StructureSelectPreviousAction.getSelectedNodeSourceRange(sr, parent);
        }
        int offset = previousNode2.getStart();
        int end = oldSourceRange.getOffset() + oldSourceRange.getLength() - 1;
        return StructureSelectionAction.createSourceRange(offset, end);
    }

    private static ASTNode getPreviousNode(ASTNode parent, ASTNode node) {
        Object[] siblingNodes = StructureSelectionAction.getSiblingNodes(node);
        if (siblingNodes == null || siblingNodes.length == 0) {
            return parent;
        }
        if (node == siblingNodes[0]) {
            return parent;
        }
        int index = StructureSelectionAction.findIndex(siblingNodes, node);
        if (index < 1) {
            return parent;
        }
        return siblingNodes[index - 1];
    }

    private static class PreviousNodeAnalyzer
    extends ApplyAll {
        private final int fOffset;
        private ASTNode fPreviousNode;

        private PreviousNodeAnalyzer(int offset) {
            this.fOffset = offset;
        }

        public static ASTNode perform(int offset, ASTNode lastCoveringNode) {
            PreviousNodeAnalyzer analyzer = new PreviousNodeAnalyzer(offset);
            lastCoveringNode.accept((Visitor)analyzer);
            return analyzer.fPreviousNode;
        }

        public boolean visit(ASTNode node) {
            int start = node.getStart();
            int end = start + node.getLength();
            if (end == this.fOffset) {
                this.fPreviousNode = node;
                return true;
            }
            return start < this.fOffset && this.fOffset < end;
        }

        protected boolean apply(ASTNode node) {
            return this.visit(node);
        }
    }
}

