/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.entities;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.eclipse.php.composer.api.collection.JsonArray;
import org.eclipse.php.composer.api.entities.JsonCollection;
import org.eclipse.php.composer.api.entities.JsonEntity;
import org.eclipse.php.composer.api.objects.JsonObject;

public class JsonValue {
    private Object value;

    public JsonValue(Object value) {
        this.value = value;
    }

    public Object toJsonValue() {
        if (this.isArray()) {
            if (this.getAsArray().size() == 0) {
                return null;
            }
            return this.buildJson(this.getAsArray());
        }
        if (this.isObject()) {
            if (this.getAsObject().size() == 0) {
                return null;
            }
            return this.buildJson(this.getAsObject());
        }
        if (this.isNumber()) {
            return this.getAsNumber();
        }
        if (this.isBoolean()) {
            return this.getAsBoolean();
        }
        return this.getAsString();
    }

    private Object buildJson(JsonCollection jsonObject) {
        try {
            Method mtd = JsonEntity.class.getDeclaredMethod("buildJson", new Class[0]);
            return mtd.invoke((Object)jsonObject, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean is(Type type) {
        return this.value.getClass().isAssignableFrom((Class)type);
    }

    public boolean isArray() {
        return this.value instanceof JsonArray;
    }

    public boolean isObject() {
        return this.value instanceof JsonObject;
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    public boolean isNumber() {
        return this.value instanceof Number;
    }

    public Object getAsRaw() {
        return this.value;
    }

    public JsonArray getAsArray() {
        if (!(this.value instanceof JsonArray)) {
            JsonArray val = new JsonArray();
            val.add(this.value);
            this.value = val;
        }
        return (JsonArray)this.value;
    }

    public String getAsString() {
        return (String)this.value;
    }

    public Boolean getAsBoolean() {
        if (this.value instanceof String) {
            return Boolean.parseBoolean((String)this.value);
        }
        return (Boolean)this.value;
    }

    public Integer getAsInteger() {
        if (this.value instanceof String) {
            return Integer.valueOf((String)this.value);
        }
        if (this.value instanceof Long) {
            return ((Long)this.value).intValue();
        }
        return (Integer)this.value;
    }

    public Float getAsFloat() {
        return Float.valueOf((String)this.value);
    }

    public Number getAsNumber() {
        return (Number)this.value;
    }

    public JsonObject getAsObject() {
        return (JsonObject)this.value;
    }
}

