/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.json;

import com.google.gson.Gson;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonFormatter {
    public static String format(Object object) {
        JsonVisitor visitor = new JsonVisitor(1, '\t');
        visitor.visit(object, 0);
        return JsonFormatter.postProcessing(visitor.toString());
    }

    private static String postProcessing(String json) {
        json = json.replace("[\n{", "[{");
        json = json.replace("},\n{", "}, {");
        return json;
    }

    private static class JsonVisitor {
        private Gson gson = new Gson();
        private final StringBuilder builder = new StringBuilder();
        private final int indentationSize;
        private final char indentationChar;

        public JsonVisitor(int indentationSize, char indentationChar) {
            this.indentationSize = indentationSize;
            this.indentationChar = indentationChar;
        }

        private void visit(List<Object> array, int indent) {
            int length = array.size();
            if (length == 0) {
                this.write("[]", 0);
            } else {
                this.writeln("[", 0);
                int i = 0;
                while (i < length) {
                    this.visit(array.get(i), indent + 1);
                    if (i < length - 1) {
                        this.writeln(",", 0);
                    }
                    ++i;
                }
                this.writeln("", 0);
                this.write("]", indent);
            }
        }

        private void visit(Map<String, Object> obj, int indent) {
            int length = obj.size();
            if (length == 0) {
                this.write("{}", 0);
            } else {
                this.writeln("{", 0);
                Iterator<String> keys = obj.keySet().iterator();
                while (keys.hasNext()) {
                    String key = keys.next();
                    this.write("\"" + JsonVisitor.escape(key) + "\" : ", indent + 1);
                    this.visit(obj.get(key), indent + 1);
                    if (!keys.hasNext()) continue;
                    this.writeln(",", 0);
                }
                this.writeln("", 0);
                this.write("}", indent);
            }
        }

        private void visit(Object object, int indent) {
            if (object instanceof List) {
                this.visit((List)object, indent);
            } else if (object instanceof Map) {
                this.visit((Map)object, indent);
            } else {
                if (this.builder.charAt(this.builder.length() - 1) != '\n') {
                    indent = 0;
                }
                if (object instanceof String) {
                    this.write("\"" + JsonVisitor.escape(String.valueOf(object)) + "\"", indent);
                } else if (object instanceof Boolean || object instanceof Number) {
                    this.write(String.valueOf(object), indent);
                } else {
                    this.write(this.gson.toJson((Object)String.valueOf(object)), indent);
                }
            }
        }

        private void writeln(String data, int indent) {
            this.write(data, indent);
            this.builder.append('\n');
        }

        private void write(String data, int indent) {
            int i = 0;
            while (i < indent * this.indentationSize) {
                this.builder.append(this.indentationChar);
                ++i;
            }
            this.builder.append(data);
        }

        public String toString() {
            return this.builder.toString();
        }

        private static String escape(String s) {
            if (s == null || s.isEmpty()) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < s.length()) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\"': {
                        sb.append("\\\"");
                        break;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        break;
                    }
                    case '\b': {
                        sb.append("\\b");
                        break;
                    }
                    case '\f': {
                        sb.append("\\f");
                        break;
                    }
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    default: {
                        if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                            String ss = Integer.toHexString(ch);
                            sb.append("\\u");
                            int k = 0;
                            while (k < 4 - ss.length()) {
                                sb.append('0');
                                ++k;
                            }
                            sb.append(ss.toUpperCase());
                            break;
                        }
                        sb.append(ch);
                    }
                }
                ++i;
            }
            return sb.toString();
        }
    }
}

