/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.php.composer.api.json.ParseException;

public class JsonParser {
    public Object parse(String json) throws ParseException {
        com.google.gson.JsonParser jsonParser = new com.google.gson.JsonParser();
        try {
            return this.buildTree(jsonParser.parse(json));
        }
        catch (JsonSyntaxException e) {
            throw this.buildException(e);
        }
    }

    private Object buildTree(JsonElement entity) {
        if (entity.isJsonPrimitive()) {
            return entity.getAsJsonPrimitive().getAsString();
        }
        if (entity.isJsonNull()) {
            return null;
        }
        if (entity.isJsonArray()) {
            LinkedList<Object> arr = new LinkedList<Object>();
            for (JsonElement el : entity.getAsJsonArray()) {
                arr.add(this.buildTree(el));
            }
            return arr;
        }
        if (entity.isJsonObject()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Map.Entry el : entity.getAsJsonObject().entrySet()) {
                map.put((String)el.getKey(), this.buildTree((JsonElement)el.getValue()));
            }
            return map;
        }
        return null;
    }

    public Object parse(Reader reader) throws ParseException, IOException {
        com.google.gson.JsonParser jsonParser = new com.google.gson.JsonParser();
        try {
            return this.buildTree(jsonParser.parse(reader));
        }
        catch (JsonSyntaxException e) {
            throw this.buildException(e);
        }
    }

    private ParseException buildException(JsonSyntaxException e) {
        ParseException pe = new ParseException(e.getCause() instanceof MalformedJsonException ? e.getCause().getMessage() : e.getMessage());
        if (e.getCause() instanceof MalformedJsonException) {
            pe.setErrorType(0);
        } else if (e.getCause() instanceof IOException) {
            pe.setErrorType(2);
        } else if (e.getCause() != null) {
            pe.setErrorType(4);
        }
        return pe;
    }
}

