/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.buildpath;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.collection.ComposerPackages;
import org.eclipse.php.composer.api.objects.Autoload;
import org.eclipse.php.composer.api.objects.Namespace;
import org.eclipse.php.composer.core.resources.IComposerProject;

public class BuildPathParser {
    private IComposerProject project;

    public BuildPathParser(IComposerProject project) {
        this.project = project;
    }

    public List<String> getPaths() {
        ComposerPackages packages = this.project.getInstalledPackages();
        if (packages == null) {
            return null;
        }
        ComposerPackage composer = this.project.getComposerPackage();
        String vendor = this.project.getVendorDir();
        ArrayList<String> paths = new ArrayList<String>();
        this.parsePackage(composer, paths);
        paths.add(String.valueOf(vendor) + "/composer");
        for (ComposerPackage p : packages) {
            this.parsePackage(p, paths, String.valueOf(vendor) + "/" + p.getName());
        }
        return paths;
    }

    private void parsePackage(ComposerPackage pkg, List<String> paths) {
        this.parsePackage(pkg, paths, "");
    }

    private void parsePackage(ComposerPackage pkg, List<String> paths, String prefix) {
        String cleanedPath;
        if (prefix != null && !prefix.equals("") && !prefix.endsWith("/")) {
            prefix = String.valueOf(prefix) + "/";
        }
        Autoload a = pkg.getAutoload();
        for (Namespace namespace : a.getPsr0()) {
            for (Object path : namespace.getPaths()) {
                this.addPath(String.valueOf(prefix) + path, paths);
            }
        }
        for (Namespace namespace : a.getPsr4()) {
            for (Object path : namespace.getPaths()) {
                this.addPath(String.valueOf(prefix) + path, paths);
            }
        }
        for (Object path : a.getClassMap()) {
            cleanedPath = this.getDirectory(String.valueOf(prefix) + (String)path);
            this.addPath(cleanedPath, paths);
        }
        for (Object path : a.getFiles()) {
            cleanedPath = this.getDirectory(String.valueOf(prefix) + (String)path);
            this.addPath(cleanedPath, paths);
        }
    }

    private String getDirectory(String path) {
        String cleanedPath = null;
        IPath root = this.project.getProject().getLocation();
        File f = new File(root.toFile(), path);
        if (f.exists()) {
            cleanedPath = f.isDirectory() ? f.getPath().replace(root.toOSString(), "") : f.getParentFile().getPath().replace(root.toOSString(), "");
        }
        return cleanedPath;
    }

    private void addPath(String path, List<String> paths) {
        if (path != null && !path.trim().isEmpty()) {
            if ((path = path.replaceAll("\\\\", "/")).startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/.")) {
                path = path.substring(0, path.length() - 2);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.equals(".")) {
                path = "";
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!paths.contains(path)) {
                paths.add(path);
            }
        }
    }
}

