/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.launch.environment;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.php.composer.core.launch.ExecutableNotFoundException;
import org.eclipse.php.composer.core.launch.LaunchUtil;
import org.eclipse.php.composer.core.launch.environment.Environment;
import org.eclipse.php.composer.core.launch.environment.EnvironmentFactory;
import org.eclipse.php.composer.core.launch.environment.PrjPharEnvironment;
import org.eclipse.php.composer.core.launch.environment.SysPhpSysPhar;

public abstract class AbstractEnvironmentFactory
implements EnvironmentFactory {
    @Override
    public Environment getEnvironment(IProject project) {
        IPreferencesService service = Platform.getPreferencesService();
        IScopeContext[] contexts = new IScopeContext[]{new ProjectScope(project), InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        String executable = service.getString(this.getPluginId(), this.getExecutableKey(), null, contexts);
        String useProjectPhar = service.getString(this.getPluginId(), this.getUseProjectKey(), null, contexts);
        String systemPhar = service.getString(this.getPluginId(), this.getScriptKey(), null, contexts);
        if (executable == null || executable.isEmpty()) {
            try {
                executable = LaunchUtil.getPHPExecutable();
            }
            catch (ExecutableNotFoundException executableNotFoundException) {}
        }
        if (executable != null && !executable.isEmpty()) {
            if (useProjectPhar != null && "true".equals(useProjectPhar) || systemPhar == null || systemPhar.length() == 0) {
                return this.getProjectEnvironment(executable);
            }
            return new SysPhpSysPhar(executable, systemPhar);
        }
        return null;
    }

    protected abstract String getPreferenceQualifier();

    protected abstract String getPluginId();

    protected abstract PrjPharEnvironment getProjectEnvironment(String var1);

    protected abstract String getExecutableKey();

    protected abstract String getUseProjectKey();

    protected abstract String getScriptKey();
}

