/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.php.composer.core.model.InstalledPackage;
import org.eclipse.php.composer.core.model.ModelAccess;
import org.eclipse.php.composer.core.model.PackageManager;

public class ComposerBuildpathContainer
implements IBuildpathContainer {
    private IScriptProject project;
    private IPath path;

    public ComposerBuildpathContainer(IPath path, IScriptProject project) {
        this.path = path;
        this.project = project;
    }

    public IPath getPath() {
        return this.path;
    }

    public int getKind() {
        return 2;
    }

    public String getDescription() {
        if (this.path.segmentCount() == 1) {
            return "Composer";
        }
        return this.path.lastSegment();
    }

    public IBuildpathEntry[] getBuildpathEntries() {
        PackageManager manager = ModelAccess.getInstance().getPackageManager();
        if (this.project == null) {
            return new IBuildpathEntry[0];
        }
        List<InstalledPackage> packages = manager.getInstalledPackages(this.project);
        if (packages == null) {
            return new IBuildpathEntry[0];
        }
        ArrayList<IBuildpathEntry> entries = new ArrayList<IBuildpathEntry>();
        for (InstalledPackage pack : packages) {
            entries.add(pack.getBuildpathEntry());
        }
        return entries.toArray(new IBuildpathEntry[entries.size()]);
    }
}

