/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.php.composer.core.facet.FacetManager;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.core.model.BuildpathPackage;
import org.eclipse.php.composer.core.model.InstalledPackage;
import org.eclipse.php.composer.core.model.PackagePath;
import org.osgi.service.prefs.BackingStoreException;

public class PackageManager {
    private Map<String, BuildpathPackage> packages;
    private Map<String, List<InstalledPackage>> installedPackages;
    private Map<String, List<InstalledPackage>> installedDevPackages;
    public static final String BP_COMPOSERPACKAGE_PREFERENCES_PREFIX = "org.eclipse.php.composer.core.composerPackage.";
    public static final String BP_PROJECT_BUILDPATH_PREFIX = "org.eclipse.php.composer.core.projectPackages#";
    public static final String BP_PROJECT_BUILDPATH_DEV_PREFIX = "org.eclipse.php.composer.core.projectDevPackages#";
    private BuildpathJob buildpathJob;

    public PackageManager() {
        this.initialize();
    }

    private void reloadPackages() {
        String[] propertyNames;
        IEclipsePreferences instancePreferences = ConfigurationScope.INSTANCE.getNode("org.eclipse.php.composer.core");
        try {
            propertyNames = instancePreferences.keys();
        }
        catch (BackingStoreException e) {
            Util.log((Throwable)e, (String)"Exception while initializing user libraries");
            return;
        }
        int i = 0;
        int length = propertyNames.length;
        while (i < length) {
            List<InstalledPackage> packages;
            String propertyValue;
            String propertyName = propertyNames[i];
            if (propertyName.startsWith(BP_PROJECT_BUILDPATH_PREFIX)) {
                propertyValue = instancePreferences.get(propertyName, null);
                if (propertyValue != null) {
                    try {
                        packages = InstalledPackage.deserialize(propertyValue);
                        this.installedPackages.put(this.unpackProjectName(propertyName), packages);
                    }
                    catch (IOException e) {
                        Logger.logException(e);
                    }
                }
            } else if (propertyName.startsWith(BP_PROJECT_BUILDPATH_DEV_PREFIX) && (propertyValue = instancePreferences.get(propertyName, null)) != null) {
                try {
                    packages = InstalledPackage.deserialize(propertyValue);
                    this.installedDevPackages.put(this.unpackProjectName(propertyName), packages);
                }
                catch (IOException e) {
                    Logger.logException(e);
                }
            }
            ++i;
        }
    }

    private String unpackProjectName(String propertyName) {
        String[] strings = propertyName.split("#");
        return strings[1];
    }

    private void initialize() {
        String[] propertyNames;
        this.packages = new HashMap<String, BuildpathPackage>();
        this.installedPackages = new HashMap<String, List<InstalledPackage>>();
        this.installedDevPackages = new HashMap<String, List<InstalledPackage>>();
        IEclipsePreferences instancePreferences = ConfigurationScope.INSTANCE.getNode("org.eclipse.php.composer.core");
        try {
            propertyNames = instancePreferences.keys();
        }
        catch (BackingStoreException e) {
            Util.log((Throwable)e, (String)"Exception while initializing user libraries");
            return;
        }
        boolean preferencesNeedFlush = false;
        int i = 0;
        int length = propertyNames.length;
        while (i < length) {
            block9: {
                String propertyValue;
                String propertyName = propertyNames[i];
                if (propertyName.startsWith(BP_COMPOSERPACKAGE_PREFERENCES_PREFIX) && (propertyValue = instancePreferences.get(propertyName, null)) != null) {
                    BuildpathPackage library;
                    String libName = propertyName.substring(BP_COMPOSERPACKAGE_PREFERENCES_PREFIX.length());
                    StringReader reader = new StringReader(propertyValue);
                    try {
                        library = BuildpathPackage.createFromString(reader);
                    }
                    catch (Exception e) {
                        Util.log((Throwable)e, (String)("Exception while initializing user library " + libName));
                        instancePreferences.remove(propertyName);
                        preferencesNeedFlush = true;
                        break block9;
                    }
                    this.packages.put(libName, library);
                }
            }
            ++i;
        }
        if (preferencesNeedFlush) {
            try {
                instancePreferences.flush();
            }
            catch (BackingStoreException e) {
                Util.log((Throwable)e, (String)"Exception while flusing instance preferences");
            }
        }
        this.buildpathJob = new BuildpathJob();
        this.reloadPackages();
    }

    public synchronized void setPackage(String name, IBuildpathEntry[] buildpathEntries, boolean isSystemLibrary) {
        IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode("org.eclipse.php.composer.core");
        String propertyName = BP_COMPOSERPACKAGE_PREFERENCES_PREFIX + this.makePackageName(name);
        try {
            String propertyValue = BuildpathPackage.serialize(buildpathEntries, isSystemLibrary);
            prefs.put(propertyName, propertyValue);
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    public void removePackage(String name) {
        try {
            IEclipsePreferences preferences = ConfigurationScope.INSTANCE.getNode("org.eclipse.php.composer.core");
            String propertyName = BP_COMPOSERPACKAGE_PREFERENCES_PREFIX + this.makePackageName(name);
            preferences.remove(propertyName);
            preferences.flush();
        }
        catch (BackingStoreException e) {
            Util.log((Throwable)e, (String)("Exception while removing user library " + name));
        }
    }

    public BuildpathPackage getPackage(String packageName) {
        if (!this.packages.containsKey(packageName)) {
            return null;
        }
        return this.packages.get(this.makePackageName(packageName));
    }

    private Object makePackageName(String packageName) {
        return "org.eclipse.php.core.PHPNature#" + packageName;
    }

    private String getPackageName(String key) {
        int pos = key.indexOf("#");
        if (pos != -1) {
            return key.substring(pos + 1);
        }
        return key;
    }

    public synchronized String[] getPackageNames() {
        Set<String> set = this.packages.keySet();
        HashSet<String> result = new HashSet<String>();
        for (String key : set) {
            result.add(this.getPackageName(key));
        }
        return result.toArray(new String[result.size()]);
    }

    public PackagePath[] getPackagePaths(IScriptProject project) {
        ArrayList<PackagePath> packagePaths = new ArrayList<PackagePath>();
        try {
            IBuildpathContainer container = ModelManager.getModelManager().getBuildpathContainer((IPath)new Path("org.eclipse.php.composer.core.CONTAINER"), project);
            IBuildpathEntry[] iBuildpathEntryArray = container.getBuildpathEntries();
            int n = iBuildpathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildpathEntry entry = iBuildpathEntryArray[n2];
                packagePaths.add(new PackagePath(entry, project));
                ++n2;
            }
        }
        catch (ModelException e) {
            Logger.logException(e.getStatus().getMessage(), e);
        }
        return packagePaths.toArray(new PackagePath[packagePaths.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBuildpath() {
        if (this.buildpathJob == null) {
            return;
        }
        BuildpathJob buildpathJob = this.buildpathJob;
        synchronized (buildpathJob) {
            this.buildpathJob.cancel();
            this.buildpathJob.setPriority(30);
            this.buildpathJob.schedule(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBuildpath(IProject project) {
        if (this.buildpathJob == null) {
            return;
        }
        BuildpathJob buildpathJob = this.buildpathJob;
        synchronized (buildpathJob) {
            this.buildpathJob.cancel();
            this.buildpathJob.setPriority(30);
            this.buildpathJob.setProject(project);
            this.buildpathJob.schedule(1000L);
        }
    }

    public List<InstalledPackage> getInstalledPackages(IScriptProject project) {
        if (this.installedPackages.containsKey(project.getProject().getName())) {
            return this.installedPackages.get(project.getProject().getName());
        }
        return null;
    }

    public List<InstalledPackage> getInstalledDevPackages(IScriptProject project) {
        if (this.installedDevPackages.containsKey(project.getProject().getName())) {
            return this.installedDevPackages.get(project.getProject().getName());
        }
        return null;
    }

    public List<InstalledPackage> getAllPackages(IScriptProject project) {
        ArrayList<InstalledPackage> allPackages = new ArrayList<InstalledPackage>();
        if (!this.installedPackages.containsKey(project.getProject().getName())) {
            return allPackages;
        }
        for (InstalledPackage pack : this.installedPackages.get(project.getProject().getName())) {
            pack.isDev = false;
            allPackages.add(pack);
        }
        if (this.installedDevPackages.containsKey(project.getProject().getName())) {
            for (InstalledPackage pack : this.installedDevPackages.get(project.getProject().getName())) {
                pack.isDev = true;
                allPackages.add(pack);
            }
        }
        return allPackages;
    }

    public void removeProject(IProject project) {
        try {
            String name = project.getName();
            String propertyName = BP_PROJECT_BUILDPATH_PREFIX + name;
            IEclipsePreferences instancePreferences = ConfigurationScope.INSTANCE.getNode("org.eclipse.php.composer.core");
            instancePreferences.remove(propertyName);
            instancePreferences.flush();
            if (this.installedPackages.containsKey(name)) {
                this.installedPackages.remove(name);
            }
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
    }

    private class BuildpathJob
    extends Job {
        private IPath installedPath;
        private IPath installedDevPath;
        private IProject project;
        private boolean running;

        public BuildpathJob() {
            super("Updating composer buildpath");
            this.installedPath = new Path("vendor/composer/installed.json");
            this.installedDevPath = new Path("vendor/composer/installed_dev.json");
        }

        public void setProject(IProject project) {
            this.project = project;
        }

        private void installLocalPackage(InstalledPackage installedPackage, IProject project) {
            IPath path = new Path("vendor").append(installedPackage.name);
            Logger.debug("Installing local version of " + installedPackage.getFullName());
            IResource resource = project.findMember(path);
            if (resource instanceof IFolder) {
                IFolder folder = (IFolder)resource;
                File file = folder.getRawLocation().makeAbsolute().toFile();
                if (file != null && file.exists() && installedPackage.getLocalFile() != null) {
                    try {
                        Logger.debug("Installing local package " + installedPackage.name + " to " + installedPackage.getLocalFile().getAbsolutePath());
                        installedPackage.getLocalFile().mkdirs();
                        final java.nio.file.Path sourcePath = file.toPath();
                        final java.nio.file.Path packagePath = installedPackage.getLocalFile().toPath();
                        SimpleFileVisitor<java.nio.file.Path> n = new SimpleFileVisitor<java.nio.file.Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(java.nio.file.Path dirPath, BasicFileAttributes attrs) throws IOException {
                                java.nio.file.Path targetPath = packagePath.resolve(sourcePath.relativize(dirPath));
                                if (!Files.exists(targetPath, new LinkOption[0])) {
                                    Files.createDirectory(targetPath, new FileAttribute[0]);
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(java.nio.file.Path filePath, BasicFileAttributes attrs) throws IOException {
                                Files.copy(filePath, packagePath.resolve(sourcePath.relativize(filePath)), StandardCopyOption.REPLACE_EXISTING);
                                return FileVisitResult.CONTINUE;
                            }
                        };
                        Files.walkFileTree(file.toPath(), (FileVisitor<? super java.nio.file.Path>)n);
                    }
                    catch (IOException e) {
                        Logger.logException(e);
                    }
                }
            } else {
                Logger.debug("Unable to find folder in project for path " + path.toString());
            }
        }

        protected void canceling() {
            super.canceling();
            this.running = false;
        }

        private void handleDevPackages(IProject project) throws Exception {
            this.handlePackages(project, PackageManager.BP_PROJECT_BUILDPATH_DEV_PREFIX + project.getName(), this.installedDevPath);
        }

        private void handleProdPackages(IProject project) throws Exception {
            this.handlePackages(project, PackageManager.BP_PROJECT_BUILDPATH_PREFIX + project.getName(), this.installedPath);
        }

        private void handlePackages(IProject project, String propertyName, IPath path) throws Exception {
            IFile installed = (IFile)project.findMember(path);
            if (installed == null) {
                Logger.debug("Unable to find '" + path.lastSegment() + "' in " + project.getName() + " using path " + path.toString());
                return;
            }
            List<InstalledPackage> json = InstalledPackage.deserialize(installed.getContents());
            this.installPackages(json, project);
            this.persist(propertyName, installed);
        }

        private void persist(String key, IFile file) throws IOException, CoreException, BackingStoreException {
            IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode("org.eclipse.php.composer.core");
            StringWriter writer = new StringWriter();
            InputStream contents = file.getContents();
            Scanner s = new Scanner(contents).useDelimiter("\\A");
            String propertyValue = s.hasNext() ? s.next() : "";
            contents.close();
            prefs.put(key, propertyValue);
            prefs.flush();
            writer.close();
        }

        private void installPackages(List<InstalledPackage> packages, IProject project) {
            Logger.debug("Installing local packages for project " + project.getName());
            for (InstalledPackage installedPackage : packages) {
                if (!installedPackage.isLocalVersionAvailable()) {
                    this.installLocalPackage(installedPackage, project);
                    continue;
                }
                Logger.debug(String.valueOf(installedPackage.getFullName()) + " is already installed locally");
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            Logger.debug("Running buildpath job");
            this.running = true;
            monitor.setTaskName("Updating composer buildpath...");
            if (this.project != null) {
                this.updateProject(this.project);
                monitor.worked(1);
            } else {
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    this.updateProject(project);
                    monitor.worked(1);
                    ++n2;
                }
            }
            PackageManager.this.reloadPackages();
            return Status.OK_STATUS;
        }

        protected void updateProject(IProject project) {
            try {
                if (!this.running) {
                    Logger.debug("Job cancelled");
                    throw new InterruptedException();
                }
                if (!FacetManager.hasComposerFacet(project)) {
                    Logger.debug("Buildpath not running on project without composer nature " + project.getName());
                    return;
                }
                IFile installed = (IFile)project.findMember(this.installedPath);
                if (installed == null) {
                    Logger.debug("Unabled to find installed.json in project " + project.getName());
                    return;
                }
                this.handleProdPackages(project);
                this.handleDevPackages(project);
                DLTKCore.refreshBuildpathContainers((IScriptProject)DLTKCore.create((IProject)project));
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
    }
}

