/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.buildpath.BuildPathUtils;

public class BuildpathUtil {
    public static void setupVendorBuildpath(IScriptProject scriptProject, IProgressMonitor progress) throws ModelException {
        IProject project = scriptProject.getProject();
        IPath composerPath = project.getFullPath().append("vendor");
        IBuildpathEntry[] rawBuildpath = scriptProject.getRawBuildpath();
        progress.setTaskName("Setting vendor buildpath...");
        IBuildpathEntry[] iBuildpathEntryArray = rawBuildpath;
        int n = rawBuildpath.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry entry = iBuildpathEntryArray[n2];
            if (entry.getPath().equals((Object)composerPath)) {
                BuildPathUtils.removeEntryFromBuildPath((IScriptProject)scriptProject, (IBuildpathEntry)entry);
            }
            ++n2;
        }
        BuildPathUtils.addEntriesToBuildPath((IScriptProject)scriptProject, BuildpathUtil.getVendorEntries(composerPath));
        progress.worked(1);
    }

    protected static List<IBuildpathEntry> getVendorEntries(IPath composerPath) {
        IPath[] include = new IPath[]{new Path("composer/*")};
        IBuildpathAttribute[] attributes = new IBuildpathAttribute[]{};
        IPath[] exclude = new IPath[]{};
        IBuildpathEntry vendorEntry = DLTKCore.newBuiltinEntry((IPath)composerPath, (IAccessRule[])new IAccessRule[0], (IBuildpathAttribute[])attributes, (IPath[])include, (IPath[])exclude, (boolean)false, (boolean)false);
        ArrayList<IBuildpathEntry> vendorEntries = new ArrayList<IBuildpathEntry>();
        vendorEntries.add(vendorEntry);
        return vendorEntries;
    }
}

