/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.test;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.php.composer.core.facet.FacetManager;
import org.eclipse.php.composer.core.model.ModelAccess;
import org.eclipse.php.composer.test.ComposerCoreTestPlugin;
import org.eclipse.php.composer.test.ComposerModelTests;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.facet.PHPFacets;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.junit.Test;

public class ReverseNamespaceResolverTest
extends ComposerModelTests {
    public ReverseNamespaceResolverTest() {
        super("Reverse Namespace Resolver tests");
    }

    @Test
    public void testNamespaceResolver() throws CoreException, IOException {
        IScriptProject scriptProject = this.ensureScriptProject("testproject2");
        ReverseNamespaceResolverTest.assertNotNull((Object)scriptProject);
        IProjectDescription desc = scriptProject.getProject().getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        scriptProject.getProject().setDescription(desc, null);
        ProjectOptions.setPhpVersion((PHPVersion)PHPVersion.PHP5_3, (IProject)scriptProject.getProject());
        PHPFacets.setFacetedVersion((IProject)scriptProject.getProject(), (PHPVersion)PHPVersion.PHP5_3);
        FacetManager.installFacets((IProject)scriptProject.getProject(), (PHPVersion)PHPVersion.PHP5_3, (IProgressMonitor)new NullProgressMonitor());
        scriptProject.getProject().refreshLocal(2, null);
        scriptProject.getProject().build(6, null);
        ComposerCoreTestPlugin.waitForIndexer();
        ComposerCoreTestPlugin.waitForAutoBuild();
        IFile file = scriptProject.getProject().getFile("composer.json");
        ReverseNamespaceResolverTest.assertNotNull((Object)file);
        ReverseNamespaceResolverTest.assertTrue((boolean)scriptProject.getProject().hasNature("org.eclipse.php.core.PHPNature"));
        ReverseNamespaceResolverTest.assertTrue((boolean)FacetManager.hasComposerFacet((IProject)scriptProject.getProject()));
        String namespace = "Foobar\\Sub";
        IPath resolvedPath = ModelAccess.getInstance().reverseResolve(scriptProject.getProject(), namespace);
        ReverseNamespaceResolverTest.assertNotNull((Object)resolvedPath);
        ReverseNamespaceResolverTest.assertTrue((boolean)scriptProject.getProject().getFolder(resolvedPath).exists());
    }
}

