/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.dialogs;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.php.composer.core.util.StringUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;

public class ComposerJobFailureDialog
extends ErrorDialog {
    public ComposerJobFailureDialog(String message, IStatus status) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Composer problem", message, status, 4);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = (Composite)super.createDialogArea(parent);
        Composite space = new Composite(main, 0);
        GridData gridData = new GridData(4, 4, false, false);
        gridData.heightHint = 1;
        gridData.widthHint = 1;
        space.setLayoutData((Object)gridData);
        Link link = this.createShowErrorLogLink(main);
        link.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        return main;
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        if (this.message != null) {
            this.messageLabel = new Label(composite, this.getMessageLabelStyle());
            this.messageLabel.setText("Composer exited with an error");
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.messageLabel);
        }
        return composite;
    }

    private Link createShowErrorLogLink(Composite parent) {
        Link link = new Link(parent, 0);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(e.text));
                }
                catch (Exception ce) {
                    ce.printStackTrace();
                }
            }
        });
        link.setText(StringUtil.replaceLinksInComposerMessage((String)this.message));
        link.setToolTipText(WorkbenchMessages.ErrorLogUtil_ShowErrorLogTooltip);
        Dialog.applyDialogFont((Control)link);
        return link;
    }
}

