/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.php.composer.api.VersionedPackage;
import org.eclipse.php.composer.ui.parts.composer.VersionSuggestion;
import org.eclipse.php.composer.ui.utils.WidgetFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DependencyDialog
extends Dialog {
    private VersionedPackage dependency;
    private Text name;
    private Text version;

    public DependencyDialog(Shell parentShell, VersionedPackage dependency) {
        super(parentShell);
        this.setShellStyle(2144);
        this.dependency = dependency;
    }

    public DependencyDialog(IShellProvider parentShell, VersionedPackage dependency) {
        super(parentShell);
        this.dependency = dependency;
    }

    public VersionedPackage getDependency() {
        return this.dependency;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Edit Dependency");
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(2, false));
        GridData gd_contents = new GridData();
        gd_contents.widthHint = 350;
        contents.setLayoutData((Object)gd_contents);
        Label lblName = new Label(contents, 0);
        GridData gd_lblName = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_lblName.widthHint = 100;
        lblName.setLayoutData((Object)gd_lblName);
        lblName.setText("Name");
        this.name = new Text(contents, 2048);
        GridData gd_name = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_name.widthHint = 175;
        this.name.setLayoutData((Object)gd_name);
        this.name.setEnabled(false);
        if (this.dependency.getName() != null) {
            this.name.setText(this.dependency.getName());
        }
        Label lblVersion = new Label(contents, 0);
        lblVersion.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblVersion.setText("Version");
        this.version = new Text(contents, 2048);
        this.version.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.dependency.getVersion() != null) {
            this.version.setText(this.dependency.getVersion());
        }
        this.version.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DependencyDialog.this.dependency.setVersion(DependencyDialog.this.version.getText());
            }
        });
        new VersionSuggestion(this.dependency.getName(), parent, this.version, null, new WidgetFactory(null));
        return contents;
    }
}

