/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.dialogs;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.php.composer.api.repositories.Repository;
import org.eclipse.php.composer.api.repositories.RepositoryFactory;
import org.eclipse.php.composer.ui.ComposerUIPluginImages;
import org.eclipse.php.internal.ui.util.ValuedCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RepositoryDialog
extends Dialog {
    private Repository repository;
    private String url;
    private String name;
    private String type;
    private static Map<String, String> repos = new HashMap<String, String>();

    static {
        repos.put("composer", "Composer");
        repos.put("package", "Package");
        repos.put("git", "Git");
        repos.put("svn", "Subversion");
        repos.put("hg", "Mercurial");
        repos.put("pear", "Pear");
    }

    public RepositoryDialog(Shell parentShell, Repository repository) {
        super(parentShell);
        this.repository = repository;
    }

    public RepositoryDialog(IShellProvider parentShell, Repository repository) {
        super(parentShell);
        this.repository = repository;
    }

    public RepositoryDialog(Shell parentShell) {
        super(parentShell);
    }

    public RepositoryDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Repository");
        this.getShell().setImage(ComposerUIPluginImages.REPO_GENERIC.createImage());
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblType = new Label(container, 0);
        GridData gd_lblType = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_lblType.widthHint = 100;
        lblType.setLayoutData((Object)gd_lblType);
        lblType.setText("Type");
        final ValuedCombo typeControl = new ValuedCombo(container, 8, this.buildEntryList());
        GridData gd_type = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_type.widthHint = 175;
        typeControl.setLayoutData((Object)gd_type);
        typeControl.setItems(repos.values().toArray(new String[0]));
        if (this.repository != null) {
            String type = this.repository.getType();
            if (repos.containsKey(type)) {
                typeControl.selectValue(type);
            }
            typeControl.setEnabled(false);
        }
        typeControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositoryDialog.this.type = typeControl.getSelectionValue();
            }
        });
        Label lblUrl = new Label(container, 0);
        lblUrl.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblUrl.setText("URL");
        final Text urlControl = new Text(container, 2048);
        urlControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.repository != null && this.repository.has("url")) {
            urlControl.setText(this.repository.getUrl());
        }
        urlControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RepositoryDialog.this.repository != null) {
                    RepositoryDialog.this.repository.setUrl(urlControl.getText());
                }
                RepositoryDialog.this.url = urlControl.getText();
            }
        });
        Label lblName = new Label(container, 0);
        lblName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblName.setText("Name");
        final Text nameControl = new Text(container, 2048);
        nameControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.repository != null && this.repository.has("name")) {
            nameControl.setText(this.repository.getName());
        }
        nameControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RepositoryDialog.this.repository != null) {
                    RepositoryDialog.this.repository.setName(nameControl.getText());
                }
                RepositoryDialog.this.name = nameControl.getText();
            }
        });
        return container;
    }

    private List<ValuedCombo.Entry> buildEntryList() {
        LinkedList<ValuedCombo.Entry> res = new LinkedList<ValuedCombo.Entry>();
        for (Map.Entry<String, String> entry : repos.entrySet()) {
            res.add(new ValuedCombo.Entry(entry.getKey(), entry.getValue()));
        }
        return res;
    }

    public Repository getRepository() {
        if (this.repository != null) {
            return this.repository;
        }
        Repository repo = RepositoryFactory.create((String)this.type);
        repo.setUrl(this.url);
        repo.setName(this.name);
        return repo;
    }
}

