/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.editor.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.php.composer.api.collection.Persons;
import org.eclipse.php.composer.api.objects.Person;
import org.eclipse.php.composer.ui.ComposerUIPluginImages;
import org.eclipse.php.composer.ui.dialogs.PersonDialog;
import org.eclipse.php.composer.ui.editor.ComposerFormPage;
import org.eclipse.php.composer.ui.editor.FormLayoutFactory;
import org.eclipse.php.composer.ui.editor.TableSection;
import org.eclipse.php.composer.ui.parts.TablePart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class AuthorSection
extends TableSection
implements PropertyChangeListener {
    private TableViewer authorViewer;
    private IAction addAction;
    private IAction editAction;
    private IAction removeAction;
    private static final int ADD_INDEX = 0;
    private static final int EDIT_INDEX = 1;
    private static final int REMOVE_INDEX = 2;

    public AuthorSection(ComposerFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{"Add...", "Edit...", "Remove"});
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText("Authors");
        section.setDescription("Honour the glorious authors of this package.");
        section.setLayoutData((Object)new TableWrapData(256));
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        TablePart tablePart = this.getTablePart();
        AuthorController authorController = new AuthorController();
        this.authorViewer = tablePart.getTableViewer();
        this.authorViewer.setContentProvider((IContentProvider)authorController);
        this.authorViewer.setLabelProvider((IBaseLabelProvider)authorController);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        this.authorViewer.setInput((Object)this.composerPackage.getAuthors());
        this.composerPackage.addPropertyChangeListener((PropertyChangeListener)this);
        this.updateButtons();
        this.makeActions();
        this.updateMenu();
    }

    @Override
    protected boolean createCount() {
        return true;
    }

    private void updateButtons() {
        ISelection selection = this.authorViewer.getSelection();
        TablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(0, this.enabled);
        tablePart.setButtonEnabled(1, !selection.isEmpty() && this.enabled);
        tablePart.setButtonEnabled(2, !selection.isEmpty() && this.enabled);
    }

    private void updateMenu() {
        IStructuredSelection selection = (IStructuredSelection)this.authorViewer.getSelection();
        this.editAction.setEnabled(selection.size() > 0);
        this.removeAction.setEnabled(selection.size() > 0);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateButtons();
        this.refresh();
        this.authorViewer.getTable().setEnabled(enabled);
    }

    public void refresh() {
        this.authorViewer.refresh();
        super.refresh();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        e.getPropertyName().startsWith("authors");
    }

    @Override
    protected void selectionChanged(IStructuredSelection sel) {
        this.updateButtons();
        this.updateMenu();
    }

    private void makeActions() {
        this.addAction = new Action("Add..."){

            public void run() {
                AuthorSection.this.handleAdd();
            }
        };
        this.editAction = new Action("Edit..."){

            public void run() {
                AuthorSection.this.handleEdit();
            }
        };
        this.removeAction = new Action("Remove"){

            public void run() {
                AuthorSection.this.handleRemove();
            }
        };
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add(this.addAction);
        manager.add(this.editAction);
        manager.add(this.removeAction);
    }

    private void handleAdd() {
        PersonDialog diag = new PersonDialog(this.authorViewer.getTable().getShell(), new Person());
        if (diag.open() == 0) {
            this.composerPackage.getAuthors().add((Object)diag.getPerson());
            this.refresh();
        }
    }

    private void handleEdit() {
        Person author = (Person)((StructuredSelection)this.authorViewer.getSelection()).getFirstElement();
        PersonDialog diag = new PersonDialog(this.authorViewer.getTable().getShell(), author.clone());
        if (diag.open() == 0) {
            author.setName(diag.getPerson().getName());
            author.setEmail(diag.getPerson().getEmail());
            author.setHomepage(diag.getPerson().getHomepage());
            author.setRole(diag.getPerson().getRole());
        }
    }

    private void handleRemove() {
        StructuredSelection selection = (StructuredSelection)this.authorViewer.getSelection();
        Iterator it = selection.iterator();
        Object[] names = new String[selection.size()];
        ArrayList<Person> persons = new ArrayList<Person>();
        int i = 0;
        while (it.hasNext()) {
            Person person = (Person)it.next();
            persons.add(person);
            names[i] = person.getName();
            ++i;
        }
        MessageDialog diag = new MessageDialog(this.authorViewer.getTable().getShell(), "Remove Author" + (selection.size() > 1 ? "s" : ""), null, "Do you really wan't to remove " + StringUtils.join((Object[])names, (String)", ") + "?", 4, new String[]{"Yes", "No"}, 0);
        if (diag.open() == 0) {
            for (Person person : persons) {
                this.composerPackage.getAuthors().remove((Object)person);
            }
        }
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleEdit();
                break;
            }
            case 2: {
                this.handleRemove();
            }
        }
    }

    class AuthorController
    extends StyledCellLabelProvider
    implements IStructuredContentProvider {
        private Persons authors;
        private Image authorImage = ComposerUIPluginImages.PERSON.createImage();

        AuthorController() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.authors = (Persons)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this.authors.toArray();
        }

        public void update(ViewerCell cell) {
            Object obj = cell.getElement();
            if (obj instanceof Person) {
                Person author = (Person)obj;
                StyledString styledString = new StyledString(author.getName());
                if (author.getEmail() != null && !author.getEmail().trim().equals("")) {
                    styledString.append(" <" + author.getEmail().trim() + ">", StyledString.COUNTER_STYLER);
                }
                if (author.getHomepage() != null && !author.getHomepage().trim().equals("")) {
                    styledString.append(" - " + author.getHomepage().trim(), StyledString.DECORATIONS_STYLER);
                }
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
                cell.setImage(this.authorImage);
                super.update(cell);
            }
        }
    }
}

