/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.job;

import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.exec.ExecuteException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.composer.core.launch.ExecutableNotFoundException;
import org.eclipse.php.composer.core.launch.ScriptLauncher;
import org.eclipse.php.composer.core.launch.ScriptLauncherManager;
import org.eclipse.php.composer.core.launch.ScriptNotFoundException;
import org.eclipse.php.composer.core.launch.execution.ExecutionResponseAdapter;
import org.eclipse.php.composer.core.launch.execution.ExecutionResponseListener;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.ui.ComposerUIPlugin;
import org.eclipse.php.composer.ui.handler.ConsoleResponseHandler;
import org.eclipse.php.composer.ui.job.DownloadJob;
import org.eclipse.php.composer.ui.job.runner.ComposerFailureMessageRunner;
import org.eclipse.php.composer.ui.job.runner.MissingExecutableRunner;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class ComposerJob
extends Job {
    private IProject project;
    private IProgressMonitor monitor;
    private boolean cancelling = false;
    private ScriptLauncher launcher;
    @Inject
    public ScriptLauncherManager manager;
    protected static final IStatus ERROR_STATUS = new Status(4, "org.eclipse.php.composer.core", "Error running composer, see log for details");

    public ComposerJob(String name) {
        super(name);
        ContextInjectionFactory.inject((Object)((Object)this), (IEclipseContext)ComposerUIPlugin.getDefault().getEclipseContext());
    }

    public ComposerJob(IProject project, String name) {
        this(name);
        this.setProject(project);
    }

    protected void canceling() {
        if (this.cancelling || this.launcher == null || !this.monitor.isCanceled()) {
            return;
        }
        this.launcher.abort();
        this.monitor.done();
        this.cancelling = true;
    }

    /*
     * Loose catch block
     */
    protected IStatus run(final IProgressMonitor monitor) {
        block11: {
            try {
                this.monitor = monitor;
                try {
                    this.launcher = this.manager.getLauncher("org.eclipse.php.composer.core.launcherfactory", this.getProject());
                }
                catch (ExecutableNotFoundException executableNotFoundException) {
                    Display.getDefault().asyncExec((Runnable)new MissingExecutableRunner());
                    IStatus iStatus = Status.OK_STATUS;
                    monitor.done();
                    return iStatus;
                }
                catch (ScriptNotFoundException scriptNotFoundException) {
                    Display.getDefault().asyncExec((Runnable)new DownloadRunner());
                    IStatus iStatus = Status.OK_STATUS;
                    monitor.done();
                    return iStatus;
                }
                this.launcher.addResponseListener((ExecutionResponseListener)new ConsoleResponseHandler());
                this.launcher.addResponseListener((ExecutionResponseListener)new ExecutionResponseAdapter(){

                    public void executionFailed(String response, Exception exception) {
                        Display.getDefault().asyncExec((Runnable)new ComposerFailureMessageRunner(response, monitor));
                    }

                    public void executionMessage(String message) {
                        if (monitor != null && message != null) {
                            monitor.subTask(message);
                            monitor.worked(1);
                        }
                    }
                });
                monitor.beginTask(this.getName(), -1);
                monitor.worked(1);
                this.launch(this.launcher);
                monitor.worked(1);
                if (this.getProject() != null) {
                    this.getProject().refreshLocal(2, null);
                    monitor.worked(1);
                }
                break block11;
                {
                    catch (Exception e) {
                        Logger.logException((Throwable)e);
                        IStatus iStatus = ERROR_STATUS;
                        return iStatus;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }

    protected abstract void launch(ScriptLauncher var1) throws ExecuteException, IOException, InterruptedException;

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    private class DownloadRunner
    implements Runnable {
        private DownloadRunner() {
        }

        @Override
        public void run() {
            Shell shell = Display.getCurrent().getActiveShell();
            if (shell == null) {
                Logger.debug((String)"Unable to get shell for message dialog.");
                return;
            }
            if (MessageDialog.openConfirm((Shell)shell, (String)"composer.phar not found", (String)"composer.phar can not be found. Download it now?")) {
                DownloadJob job = new DownloadJob(ComposerJob.this.getProject());
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        ComposerJob.this.schedule();
                    }
                });
                job.setUser(true);
                job.schedule();
            }
        }
    }
}

