/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.utils;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class WidgetFactory {
    protected FormToolkit toolkit;

    public WidgetFactory(FormToolkit toolkit) {
        this.toolkit = toolkit;
    }

    private static WidgetFactory builder(FormToolkit toolkit) {
        return new WidgetFactory(toolkit);
    }

    public Button createButton(Composite parent) {
        return this.createButton(parent, -1);
    }

    public static Button createButton(FormToolkit toolkit, Composite parent) {
        return WidgetFactory.builder(toolkit).createButton(parent);
    }

    public Button createButton(Composite parent, int style) {
        if (this.toolkit == null) {
            return new Button(parent, style);
        }
        return this.toolkit.createButton(parent, "", style);
    }

    public static Button createButton(FormToolkit toolkit, Composite parent, int style) {
        return WidgetFactory.builder(toolkit).createButton(parent, style);
    }

    public Label createLabel(Composite parent) {
        return this.createLabel(parent, 0);
    }

    public static Label createLabel(FormToolkit toolkit, Composite parent) {
        return WidgetFactory.builder(toolkit).createLabel(parent);
    }

    public Label createLabel(Composite parent, int style) {
        if (this.toolkit == null) {
            return new Label(parent, style);
        }
        return this.toolkit.createLabel(parent, "", style);
    }

    public static Label createLabel(FormToolkit toolkit, Composite parent, int style) {
        return WidgetFactory.builder(toolkit).createLabel(parent, style);
    }

    public Composite createComposite(Composite parent) {
        return this.createComposite(parent, 0);
    }

    public static Composite createComposite(FormToolkit toolkit, Composite parent) {
        return WidgetFactory.builder(toolkit).createComposite(parent);
    }

    public Composite createComposite(Composite parent, int style) {
        if (this.toolkit == null) {
            return new Composite(parent, style);
        }
        return this.toolkit.createComposite(parent, style);
    }

    public static Composite createComposite(FormToolkit toolkit, Composite parent, int style) {
        return WidgetFactory.builder(toolkit).createComposite(parent, style);
    }

    public ExpandableComposite createExpandableComposite(Composite parent) {
        return this.createExpandableComposite(parent, 0);
    }

    public static ExpandableComposite createExpandableComposite(FormToolkit toolkit, Composite parent) {
        return WidgetFactory.builder(toolkit).createExpandableComposite(parent);
    }

    public ExpandableComposite createExpandableComposite(Composite parent, int style) {
        if (this.toolkit == null) {
            return new ExpandableComposite(parent, style);
        }
        return this.toolkit.createExpandableComposite(parent, style);
    }

    public static ExpandableComposite createExpandableComposite(FormToolkit toolkit, Composite parent, int style) {
        return WidgetFactory.builder(toolkit).createExpandableComposite(parent, style);
    }

    public ExpandableComposite createExpandableComposite(Composite parent, int style, int expansionStyle) {
        if (this.toolkit == null) {
            return new ExpandableComposite(parent, style, expansionStyle);
        }
        ExpandableComposite ec = new ExpandableComposite(parent, style | this.toolkit.getOrientation(), expansionStyle);
        ec.setMenu(parent.getMenu());
        this.toolkit.adapt((Control)ec, true, true);
        return ec;
    }

    public Text createText(Composite parent) {
        return this.createText(parent, -1);
    }

    public static Text createText(FormToolkit toolkit, Composite parent) {
        return WidgetFactory.builder(toolkit).createText(parent);
    }

    public Text createText(Composite parent, int style) {
        if (this.toolkit == null) {
            return new Text(parent, style);
        }
        return this.toolkit.createText(parent, "", style);
    }

    public static Text createText(FormToolkit toolkit, Composite parent, int style) {
        return WidgetFactory.builder(toolkit).createText(parent, style);
    }

    public Combo createCombo(Composite parent) {
        return this.createCombo(parent, 2048);
    }

    public static Combo createCombo(FormToolkit toolkit, Composite parent) {
        return WidgetFactory.builder(toolkit).createCombo(parent);
    }

    public Combo createCombo(Composite parent, int style) {
        if (this.toolkit == null) {
            return new Combo(parent, style);
        }
        Combo combo = new Combo(parent, style);
        this.toolkit.adapt((Control)combo, false, false);
        return combo;
    }

    public static Combo createCombo(FormToolkit toolkit, Composite parent, int style) {
        return WidgetFactory.builder(toolkit).createCombo(parent, style);
    }
}

