/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.ui.wizards.NewElementWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.php.composer.core.facet.FacetManager;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.ui.wizard.AbstractWizardFirstPage;
import org.eclipse.php.composer.ui.wizard.AbstractWizardSecondPage;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public abstract class AbstractComposerWizard
extends NewElementWizard
implements INewWizard,
IExecutableExtension {
    protected AbstractWizardFirstPage firstPage;
    protected AbstractWizardSecondPage secondPage;
    protected AbstractWizardSecondPage lastPage;
    protected IConfigurationElement config;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.config = config;
    }

    public void addPages() {
        super.addPages();
        this.firstPage = this.getFirstPage();
        this.addPage((IWizardPage)this.firstPage);
        this.secondPage = this.getSecondPage();
        this.addPage((IWizardPage)this.secondPage);
        this.lastPage = this.secondPage;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (this.firstPage != null) {
            this.firstPage.performFinish(monitor);
        }
        if (this.secondPage != null) {
            this.secondPage.performFinish(monitor);
        }
    }

    public IModelElement getCreatedElement() {
        return DLTKCore.create((IProject)this.firstPage.getProjectHandle());
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
            this.selectAndReveal((IResource)this.lastPage.getScriptProject().getProject());
            IProject project = this.lastPage.getScriptProject().getProject();
            PHPVersion version = this.firstPage.getPHPVersionValue();
            if (version == null) {
                version = ProjectOptions.getDefaultPhpVersion();
            }
            FacetManager.installFacets((IProject)project, (PHPVersion)version, null);
            IFile json = project.getFile("composer.json");
            if (json != null) {
                try {
                    FileEditorInput editorInput = new FileEditorInput(json);
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage page = window.getActivePage();
                    page.openEditor((IEditorInput)editorInput, "org.eclipse.php.composer.ui.editor.composer.ComposerEditor");
                }
                catch (Exception e) {
                    Logger.logException((Throwable)e);
                }
            }
        }
        return res;
    }

    public boolean performCancel() {
        this.secondPage.cancel();
        return super.performCancel();
    }

    protected abstract AbstractWizardFirstPage getFirstPage();

    protected abstract AbstractWizardSecondPage getSecondPage();
}

