/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.wizard.importer;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.utils.ResourceUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.php.composer.core.facet.FacetManager;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.ui.ComposerUIPluginImages;
import org.eclipse.php.composer.ui.wizard.importer.WizardResourceImportPage;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ComposerImportWizard
extends Wizard
implements IImportWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private WizardResourceImportPage mainPage;

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.selection = currentSelection;
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)currentSelection);
        if (!selectedResources.isEmpty()) {
            this.selection = new StructuredSelection(selectedResources);
        }
        this.setWindowTitle(DataTransferMessages.DataTransfer_importTitle);
        this.setDefaultPageImageDescriptor(ComposerUIPluginImages.IMPORT_PROJECT);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardResourceImportPage(this.workbench, this.selection, this.getFileImportMask());
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot root = workspace.getRoot();
                String projectName = ComposerImportWizard.this.mainPage.getProjectName();
                IProject project = root.getProject(ComposerImportWizard.this.mainPage.getProjectName());
                monitor.beginTask("Importing composer project", 5);
                try {
                    try {
                        Path locationPath = new Path(ComposerImportWizard.this.mainPage.getSourcePath());
                        IProjectDescription description = null;
                        if (locationPath.append(".project").toFile().exists()) {
                            ProjectDescriptionReader reader = new ProjectDescriptionReader(project);
                            description = reader.read(locationPath.append(".project"));
                        } else {
                            description = workspace.newProjectDescription(projectName);
                        }
                        if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                            description.setLocation(null);
                        } else {
                            description.setLocation((IPath)locationPath);
                        }
                        monitor.worked(1);
                        project.create(description, monitor);
                        project.open(monitor);
                        monitor.worked(1);
                        if (!project.hasNature("org.eclipse.php.core.PHPNature")) {
                            ResourceUtil.addNature((IProject)project, (IProgressMonitor)monitor, (String)"org.eclipse.php.core.PHPNature");
                        }
                        ProjectFacetsManager.create((IProject)project);
                        FacetManager.installFacets((IProject)project, (PHPVersion)PHPVersion.PHP5_4, (IProgressMonitor)monitor);
                        monitor.worked(1);
                        project.refreshLocal(2, monitor);
                        monitor.worked(2);
                    }
                    catch (CoreException e) {
                        Logger.logException((Throwable)e);
                        monitor.done();
                    }
                    catch (IOException e) {
                        Logger.logException((Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, true, op);
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
            return false;
        }
        return true;
    }

    protected String[] getFileImportMask() {
        return null;
    }
}

