/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.wizard.importer;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.json.ParseException;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.ui.wizard.ValidationException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardDataTransferPage;

public class WizardResourceImportPage
extends WizardDataTransferPage {
    protected String source;
    protected String target;
    protected String projectName;
    protected StringButtonDialogField sourcePath;
    protected IPath json;
    protected ComposerPackage composerPackage;
    protected StringDialogField projectNameField;
    protected IWorkspace workspace;
    protected StringButtonDialogField targetPath;
    protected Button useWorkspaceLocation;
    protected final String defaultMessage = "Select an existing Composer project to automatically setup your project";
    protected String lastNameFromProjectFile = null;
    protected boolean useWorkspace = true;

    public WizardResourceImportPage(IWorkbench aWorkbench, IStructuredSelection selection, String[] strings) {
        super("Import existing Composer project");
        this.setTitle("Import an existing Composer project");
        this.setDescription("Select an existing Composer project to automatically setup your project");
    }

    public void handleEvent(Event event) {
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getSourcePath() {
        return this.source;
    }

    public String getTargetPath() {
        return this.target;
    }

    public boolean doUseWorkspace() {
        return this.useWorkspace;
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        int numColumns = 3;
        GridLayoutFactory.fillDefaults().numColumns(numColumns).applyTo(control);
        this.projectNameField = new StringDialogField();
        this.projectNameField.setLabelText("Project name");
        this.projectNameField.doFillIntoGrid(control, numColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.projectNameField.getTextControl(null));
        this.projectNameField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                WizardResourceImportPage.this.projectName = WizardResourceImportPage.this.projectNameField.getText();
                WizardResourceImportPage.this.updatePageCompletion();
            }
        });
        this.sourcePath = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                DirectoryDialog dialog = new DirectoryDialog(WizardResourceImportPage.this.getShell(), 4096);
                dialog.setMessage("Select an existing composer project");
                WizardResourceImportPage.this.source = dialog.open();
                try {
                    WizardResourceImportPage.this.handleSourcePathChange();
                }
                catch (Exception e) {
                    Logger.logException((Throwable)e);
                }
            }
        });
        this.sourcePath.setLabelText("Source path");
        this.sourcePath.setButtonLabel("Browse");
        this.sourcePath.doFillIntoGrid(control, numColumns);
        this.sourcePath.getTextControl(null).setEnabled(false);
        this.useWorkspaceLocation = new Button(control, 32);
        this.useWorkspaceLocation.setText("Use default workspace location");
        this.useWorkspaceLocation.setSelection(true);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.useWorkspaceLocation);
        this.useWorkspaceLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardResourceImportPage.this.targetPath.setEnabled(!WizardResourceImportPage.this.useWorkspaceLocation.getSelection());
                WizardResourceImportPage.this.useWorkspace = WizardResourceImportPage.this.useWorkspaceLocation.getSelection();
                WizardResourceImportPage.this.updatePageCompletion();
            }
        });
        this.useWorkspaceLocation.setVisible(false);
        LayoutUtil.setHorizontalGrabbing((Control)this.sourcePath.getTextControl(null));
        this.setControl((Control)control);
        this.workspace = ResourcesPlugin.getWorkspace();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)control, "org.eclipse.php.composer.ui.help_context_wizard_importer");
        this.setPageComplete(false);
    }

    protected void handleTargetPathChange() throws IOException {
        this.updatePageCompletion();
    }

    protected void handleSourcePathChange() throws IOException, ParseException {
        if (this.source != null) {
            this.sourcePath.setText(this.source);
            this.json = new Path(this.source).append("composer.json");
            this.composerPackage = this.json != null && this.json.toFile().exists() ? new ComposerPackage(this.json.toFile()) : null;
            this.setProjectNameFromJson();
        }
        this.updatePageCompletion();
    }

    protected void setProjectNameFromJson() {
        if (this.projectNameField.getText().length() > 0 || this.composerPackage == null) {
            return;
        }
        String name = this.composerPackage.getName();
        if (name != null) {
            String[] split;
            if (name.contains("/") && (split = name.split("/")).length == 2) {
                name = split[1];
            }
            try {
                this.validateProjectName(name);
            }
            catch (ValidationException e) {
                this.setErrorMessage(e.getMessage());
                this.updatePageCompletion();
                return;
            }
            this.projectNameField.setText(name);
        }
    }

    protected void validateProjectName(String name) throws ValidationException {
        IProject project = this.workspace.getRoot().getProject(name);
        if (project != null && project.exists()) {
            throw new ValidationException("A project with the same name already exists in the workspace", ValidationException.Severity.ERROR);
        }
    }

    protected boolean validateSourceGroup() {
        this.projectNameField.getTextControl(null).setEnabled(true);
        if (this.json == null || !this.json.toFile().exists()) {
            this.setErrorMessage("The selected folder does not contain a composer.json file.");
            return false;
        }
        IPath sourceProject = new Path(this.source).append(".project");
        if (sourceProject.toFile().exists()) {
            ProjectDescription projectDescription;
            block5: {
                try {
                    ProjectDescriptionReader reader = new ProjectDescriptionReader();
                    projectDescription = reader.read(sourceProject);
                    if (projectDescription != null) break block5;
                    this.setErrorMessage("Cannot read the source project.");
                    return false;
                }
                catch (IOException e) {
                    Logger.logException((Throwable)e);
                    this.setErrorMessage("Error reading source project");
                    return false;
                }
            }
            this.projectName = projectDescription.getName();
            this.projectNameField.setTextWithoutUpdate(this.projectName);
            this.projectNameField.getTextControl(null).setEnabled(false);
            this.lastNameFromProjectFile = this.projectName;
            this.setMessage("The target location contains already an eclipse project. The wizard will use the existing information to import the project");
            return true;
        }
        this.projectNameField.getTextControl(null).setEnabled(true);
        this.setMessage("Select an existing Composer project to automatically setup your project");
        return true;
    }

    protected boolean validateDestinationGroup() {
        if (this.projectName == null || this.projectName.length() == 0) {
            this.setErrorMessage("Please enter a project name");
            return false;
        }
        try {
            this.validateProjectName(this.projectName);
        }
        catch (ValidationException e) {
            this.setErrorMessage(e.getMessage());
            return false;
        }
        if (this.useWorkspaceLocation.getSelection()) {
            return true;
        }
        if (this.target == null) {
            this.setMessage("Please select a target path");
            return false;
        }
        Path targetPath = new Path(this.target);
        File file = targetPath.toFile();
        if (file == null || !file.exists() || !file.isDirectory()) {
            this.setErrorMessage("The selected target location is invalid");
            return false;
        }
        IPath targetProjectPath = targetPath.append(this.projectName);
        File targetProject = targetProjectPath.toFile();
        if (targetProject == null || targetProject.exists()) {
            this.setErrorMessage("The target folder already contains a file/folder with the specified project name");
            return false;
        }
        this.setMessage("Select an existing Composer project to automatically setup your project");
        return true;
    }

    protected boolean allowNewContainerName() {
        return false;
    }
}

