/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.wizard.project.template;

import java.util.Observer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.ui.converter.String2KeywordsConverter;
import org.eclipse.php.composer.ui.wizard.LocationGroup;
import org.eclipse.php.composer.ui.wizard.project.BasicSettingsGroup;
import org.eclipse.php.composer.ui.wizard.project.ComposerProjectWizardFirstPage;
import org.eclipse.php.composer.ui.wizard.project.template.Validator;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.ui.wizards.CompositeData;
import org.eclipse.php.internal.ui.wizards.NameGroup;
import org.eclipse.php.internal.ui.wizards.PHPProjectWizardFirstPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class PackageProjectWizardFirstPage
extends ComposerProjectWizardFirstPage
implements IShellProvider {
    private Validator projectTemplateValidator;
    private Button overrideComposer;
    private boolean doesOverride = false;

    public PackageProjectWizardFirstPage() {
        this.setPageComplete(false);
        this.setTitle("Basic Composer Configuration");
        this.setDescription("Create a new project from existing package");
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), false));
        composite.setLayoutData((Object)new GridData(256));
        this.initialName = "";
        this.nameGroup = new NameGroup(composite, this.initialName, this.getShell());
        this.nameGroup.addObserver((Observer)this);
        this.PHPLocationGroup = new LocationGroup(composite, this.nameGroup, this.getShell());
        this.overrideComposer = new Button(composite, 32);
        this.overrideComposer.setText("Override composer.json from target package");
        this.overrideComposer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackageProjectWizardFirstPage.this.doesOverride = PackageProjectWizardFirstPage.this.overrideComposer.getSelection();
                PackageProjectWizardFirstPage.this.settingsGroup.setEnabled(PackageProjectWizardFirstPage.this.overrideComposer.getSelection());
            }
        });
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText("");
        this.settingsGroup = new BasicSettingsGroup((Composite)group, this.getShell());
        this.settingsGroup.setEnabled(false);
        this.settingsGroup.addObserver(this);
        CompositeData data = new CompositeData();
        data.setParetnt(composite);
        data.setSettings(this.getDialogSettings());
        data.setObserver((Observer)this.PHPLocationGroup);
        this.versionGroup = new PHPProjectWizardFirstPage.VersionGroup(this, composite, PHPVersion.PHP5_3){

            public IEnvironment getEnvironment() {
                return PackageProjectWizardFirstPage.this.getEnvironment();
            }
        };
        this.nameGroup.addObserver((Observer)this.PHPLocationGroup);
        this.nameGroup.notifyObservers();
        this.projectTemplateValidator = new Validator(this);
        this.nameGroup.addObserver((Observer)this.projectTemplateValidator);
        this.PHPLocationGroup.addObserver(this.projectTemplateValidator);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.composerPackage = new ComposerPackage();
        this.keywordConverter = new String2KeywordsConverter(this.composerPackage);
        this.setHelpContext((Control)composite);
    }

    @Override
    public void performFinish(IProgressMonitor monitor) {
    }

    @Override
    protected void setHelpContext(Control container) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(container, "org.eclipse.php.composer.ui.help_context_wizard_template_firstpage");
    }

    public boolean doesOverrideComposer() {
        return this.doesOverride;
    }
}

