/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.errors;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.errors.MarkerComparator;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.PHPVersion;
import org.junit.Test;

public abstract class AbstractErrorReportingTests {
    protected IProject project;
    protected int count;
    protected final String[] fileNames;
    protected Map<String, IFile> files = new HashMap<String, IFile>();
    protected Map<String, PdttFile> pdttFiles = new HashMap<String, PdttFile>();

    public AbstractErrorReportingTests(String[] fileNames) {
        this.fileNames = fileNames;
    }

    @Test
    public void errors(String fileName) throws Exception {
        IFile file = this.files.get(fileName);
        StringBuilder buf = new StringBuilder();
        IMarker[] markers = file.findMarkers(this.getMarkerType(), true, 0);
        Arrays.sort(markers, new MarkerComparator());
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            buf.append("\n[line=");
            buf.append(marker.getAttribute("lineNumber"));
            buf.append(", start=");
            buf.append(marker.getAttribute("charStart"));
            buf.append(", end=");
            buf.append(marker.getAttribute("charEnd"));
            buf.append("] ");
            buf.append(marker.getAttribute("message")).append('\n');
            ++n2;
        }
        PDTTUtils.assertContents(this.pdttFiles.get(fileName).getExpected(), buf.toString());
    }

    protected IFile createFile(String data) throws Exception {
        return TestUtils.createFile(this.project, "test" + ++this.count + ".php", data);
    }

    @PDTTList.AfterList
    public void tearDown() throws Exception {
        TestUtils.deleteProject(this.project);
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = TestUtils.createProject("ErrorReportingTests");
        ResourcesPlugin.getWorkspace().getRoot().getProject(this.getPHPVersion() + "ErrorReportingTests");
        String[] stringArray = this.fileNames;
        int n = this.fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            PdttFile pdttFile = new PdttFile(fileName);
            this.pdttFiles.put(fileName, pdttFile);
            this.files.put(fileName, this.createFile(pdttFile.getFile().trim()));
            ++n2;
        }
        TestUtils.setProjectPhpVersion(this.project, this.getPHPVersion());
        this.project.build(6, null);
        TestUtils.waitForIndexer();
    }

    protected abstract PHPVersion getPHPVersion();

    protected String getMarkerType() {
        return "org.eclipse.php.core.phpproblemmarker";
    }
}

