/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.AnonymousClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ClassInstanceCreation
extends VariableBase {
    private ClassName className;
    private ASTNode.NodeList<Expression> ctorParams = new ASTNode.NodeList(CTOR_PARAMS_PROPERTY);
    private AnonymousClassDeclaration anonymousClassDeclaration;
    public static final ChildPropertyDescriptor CLASSNAME_PROPERTY = new ChildPropertyDescriptor(ClassInstanceCreation.class, "className", ClassName.class, true, true);
    public static final ChildListPropertyDescriptor CTOR_PARAMS_PROPERTY = new ChildListPropertyDescriptor(ClassInstanceCreation.class, "ctorParams", Expression.class, true);
    public static final ChildPropertyDescriptor ANONYMOUS_CLASS_PROPERTY = new ChildPropertyDescriptor(ClassInstanceCreation.class, "anonymousClass", AnonymousClassDeclaration.class, false, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(3);
        propertyList.add(CLASSNAME_PROPERTY);
        propertyList.add(CTOR_PARAMS_PROPERTY);
        propertyList.add(ANONYMOUS_CLASS_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    @Deprecated
    public ClassInstanceCreation(int start, int end, AST ast, ClassName className, Expression[] ctorParams) {
        this(start, end, ast, className, ctorParams == null ? null : Arrays.asList(ctorParams));
    }

    @Deprecated
    public ClassInstanceCreation(int start, int end, AST ast, ClassName className, Expression[] ctorParams, AnonymousClassDeclaration anonymousClassDeclaration) {
        this(start, end, ast, className, ctorParams == null ? null : Arrays.asList(ctorParams), anonymousClassDeclaration);
    }

    public ClassInstanceCreation(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    public ClassInstanceCreation(int start, int end, AST ast, ClassName className, List<Expression> ctorParams) {
        super(start, end, ast);
        if (className == null || ctorParams == null) {
            throw new IllegalArgumentException();
        }
        this.setClassName(className);
        this.ctorParams.addAll(ctorParams);
    }

    public ClassInstanceCreation(int start, int end, AST ast, ClassName className, List<Expression> ctorParams, AnonymousClassDeclaration anonymousClassDeclaration) {
        super(start, end, ast);
        if (className == null || anonymousClassDeclaration == null || ctorParams == null) {
            throw new IllegalArgumentException();
        }
        this.setClassName(className);
        this.setAnonymousClassDeclaration(anonymousClassDeclaration);
        this.ctorParams.addAll(ctorParams);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        if (this.className != null) {
            this.className.accept(visitor);
        }
        for (ASTNode aSTNode : this.ctorParams) {
            aSTNode.accept(visitor);
        }
        if (this.anonymousClassDeclaration != null) {
            this.anonymousClassDeclaration.childrenAccept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        if (this.className != null) {
            this.className.traverseTopDown(visitor);
        }
        for (ASTNode aSTNode : this.ctorParams) {
            aSTNode.traverseTopDown(visitor);
        }
        if (this.anonymousClassDeclaration != null) {
            this.anonymousClassDeclaration.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        if (this.className != null) {
            this.className.traverseBottomUp(visitor);
        }
        for (ASTNode aSTNode : this.ctorParams) {
            aSTNode.traverseBottomUp(visitor);
        }
        if (this.anonymousClassDeclaration != null) {
            this.anonymousClassDeclaration.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ClassInstanceCreation");
        this.appendInterval(buffer);
        buffer.append(">\n");
        if (this.className != null) {
            this.className.toString(buffer, "\t" + tab);
        }
        buffer.append("\n").append("\t").append(tab).append("<ConstructorParameters>\n");
        for (ASTNode aSTNode : this.ctorParams) {
            aSTNode.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</ConstructorParameters>\n");
        if (this.getAnonymousClassDeclaration() != null) {
            this.getAnonymousClassDeclaration().toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</ClassInstanceCreation>");
    }

    @Override
    public int getType() {
        return 13;
    }

    public ClassName getClassName() {
        return this.className;
    }

    public void setClassName(ClassName classname) {
        if (classname == null) {
            throw new IllegalArgumentException();
        }
        ClassName oldChild = this.className;
        this.preReplaceChild(oldChild, classname, CLASSNAME_PROPERTY);
        this.className = classname;
        this.postReplaceChild(oldChild, classname, CLASSNAME_PROPERTY);
    }

    public AnonymousClassDeclaration getAnonymousClassDeclaration() {
        return this.anonymousClassDeclaration;
    }

    public void setAnonymousClassDeclaration(AnonymousClassDeclaration anonymousClassDeclaration) {
        if (anonymousClassDeclaration == null) {
            throw new IllegalArgumentException();
        }
        AnonymousClassDeclaration oldChild = this.anonymousClassDeclaration;
        this.preReplaceChild(oldChild, anonymousClassDeclaration, ANONYMOUS_CLASS_PROPERTY);
        this.anonymousClassDeclaration = anonymousClassDeclaration;
        this.postReplaceChild(oldChild, anonymousClassDeclaration, ANONYMOUS_CLASS_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == CLASSNAME_PROPERTY) {
            if (get) {
                return this.getClassName();
            }
            this.setClassName((ClassName)child);
            return null;
        }
        if (property == ANONYMOUS_CLASS_PROPERTY) {
            if (get) {
                return this.getAnonymousClassDeclaration();
            }
            this.setAnonymousClassDeclaration((AnonymousClassDeclaration)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    public List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == CTOR_PARAMS_PROPERTY) {
            return this.ctorParams();
        }
        return super.internalGetChildListProperty(property);
    }

    public List<Expression> ctorParams() {
        return this.ctorParams;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        List<Expression> params = ASTNode.copySubtrees(target, this.ctorParams());
        AnonymousClassDeclaration acd = ASTNode.copySubtree(target, this.getAnonymousClassDeclaration());
        ClassName cn = ASTNode.copySubtree(target, this.getClassName());
        return new ClassInstanceCreation(this.getStart(), this.getEnd(), target, cn, params, acd);
    }

    public ClassInstanceCreation cloneWithNewStart(int offset) {
        AST target = this.getAST();
        List<Expression> params = ASTNode.copySubtrees(target, this.ctorParams());
        ClassName cn = ASTNode.copySubtree(target, this.getClassName());
        ClassInstanceCreation result = new ClassInstanceCreation(offset, this.getEnd(), target, cn, params);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public IMethodBinding resolveConstructorBinding() {
        return this.ast.getBindingResolver().resolveConstructor(this);
    }
}

