/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.Reference;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class FormalParameter
extends ASTNode {
    private Expression parameterType;
    private Expression parameterName;
    private Expression defaultValue;
    private boolean isMandatory;
    private boolean isVariadic;
    public static final ChildPropertyDescriptor PARAMETER_TYPE_PROPERTY = new ChildPropertyDescriptor(FormalParameter.class, "parameterType", Expression.class, false, true);
    public static final ChildPropertyDescriptor PARAMETER_NAME_PROPERTY = new ChildPropertyDescriptor(FormalParameter.class, "expression", Expression.class, true, true);
    public static final ChildPropertyDescriptor DEFAULT_VALUE_PROPERTY = new ChildPropertyDescriptor(FormalParameter.class, "defaultValue", Expression.class, false, true);
    public static final SimplePropertyDescriptor IS_MANDATORY_PROPERTY = new SimplePropertyDescriptor(FormalParameter.class, "isMandatory", Boolean.class, false);
    public static final SimplePropertyDescriptor IS_VARIADIC_PROPERTY = new SimplePropertyDescriptor(FormalParameter.class, "isVariadic", Boolean.class, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS_PHP5;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(4);
        properyList.add(PARAMETER_TYPE_PROPERTY);
        properyList.add(PARAMETER_NAME_PROPERTY);
        properyList.add(DEFAULT_VALUE_PROPERTY);
        properyList.add(IS_VARIADIC_PROPERTY);
        PROPERTY_DESCRIPTORS_PHP5 = Collections.unmodifiableList(properyList);
        properyList = new ArrayList(4);
        properyList.add(PARAMETER_TYPE_PROPERTY);
        properyList.add(PARAMETER_NAME_PROPERTY);
        properyList.add(DEFAULT_VALUE_PROPERTY);
        properyList.add(IS_MANDATORY_PROPERTY);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS_PHP5;
    }

    public FormalParameter(AST ast) {
        super(ast);
    }

    public FormalParameter(int start, int end, AST ast, Expression type, Expression parameterName, Expression defaultValue, boolean isMandatory, boolean isVariadic) {
        super(start, end, ast);
        if (parameterName == null) {
            throw new IllegalArgumentException();
        }
        this.setParameterName(parameterName);
        if (type != null) {
            this.setParameterType(type);
        }
        if (defaultValue != null) {
            this.setDefaultValue(defaultValue);
        }
        this.setIsMandatory(isMandatory);
        this.setIsVariadic(isVariadic);
    }

    private FormalParameter(int start, int end, AST ast, Expression type, Expression parameterName, Expression defaultValue, boolean isMandatory) {
        this(start, end, ast, type, parameterName, defaultValue, isMandatory, false);
    }

    public FormalParameter(int start, int end, AST ast, Expression type, Variable parameterName, Expression defaultValue) {
        this(start, end, ast, type, parameterName, defaultValue, false);
    }

    public FormalParameter(int start, int end, AST ast, Expression type, Reference parameterName, Expression defaultValue) {
        this(start, end, ast, type, parameterName, defaultValue, false);
    }

    public FormalParameter(int start, int end, AST ast, Expression type, Variable parameterName) {
        this(start, end, ast, type, parameterName, null, false);
    }

    public FormalParameter(int start, int end, AST ast, Expression type, Variable parameterName, boolean isMandatory) {
        this(start, end, ast, type, parameterName, null, isMandatory);
    }

    public FormalParameter(int start, int end, AST ast, Expression type, Reference parameterName) {
        this(start, end, ast, type, parameterName, null, false);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        if (this.parameterType != null) {
            this.parameterType.accept(visitor);
        }
        this.parameterName.accept(visitor);
        if (this.defaultValue != null) {
            this.defaultValue.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        if (this.parameterType != null) {
            this.parameterType.traverseTopDown(visitor);
        }
        this.parameterName.traverseTopDown(visitor);
        if (this.defaultValue != null) {
            this.defaultValue.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        if (this.parameterType != null) {
            this.parameterType.traverseBottomUp(visitor);
        }
        this.parameterName.traverseBottomUp(visitor);
        if (this.defaultValue != null) {
            this.defaultValue.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<FormalParameter");
        this.appendInterval(buffer);
        buffer.append(" isMandatory='").append(this.isMandatory);
        if (this.isVariadic()) {
            buffer.append(" isVariadic='").append(this.isVariadic);
        }
        buffer.append("'>\n");
        buffer.append("\t").append(tab).append("<Type>\n");
        if (this.parameterType != null) {
            this.parameterType.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</Type>\n");
        buffer.append("\t").append(tab).append("<ParameterName>\n");
        this.parameterName.toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("</ParameterName>\n");
        buffer.append("\t").append(tab).append("<DefaultValue>\n");
        if (this.defaultValue != null) {
            this.defaultValue.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</DefaultValue>\n");
        buffer.append(tab).append("</FormalParameter>");
    }

    @Override
    public int getType() {
        return 27;
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Expression value) {
        Expression oldChild = this.defaultValue;
        this.preReplaceChild(oldChild, value, DEFAULT_VALUE_PROPERTY);
        this.defaultValue = value;
        this.postReplaceChild(oldChild, value, DEFAULT_VALUE_PROPERTY);
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public void setIsMandatory(boolean isMandatory) {
        this.preValueChange(IS_MANDATORY_PROPERTY);
        this.isMandatory = isMandatory;
        this.postValueChange(IS_MANDATORY_PROPERTY);
    }

    public boolean isVariadic() {
        return this.isVariadic;
    }

    public void setIsVariadic(boolean isVariadic) {
        this.preValueChange(IS_VARIADIC_PROPERTY);
        this.isVariadic = isVariadic;
        this.postValueChange(IS_VARIADIC_PROPERTY);
    }

    public Expression getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(Expression name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.parameterName;
        this.preReplaceChild(oldChild, name, PARAMETER_NAME_PROPERTY);
        this.parameterName = name;
        this.postReplaceChild(oldChild, name, PARAMETER_NAME_PROPERTY);
    }

    public Expression getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(Expression id) {
        if (id != null && !(id instanceof Identifier) && !(id instanceof NamespaceName)) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.parameterType;
        this.preReplaceChild(oldChild, id, PARAMETER_TYPE_PROPERTY);
        this.parameterType = id;
        this.postReplaceChild(oldChild, id, PARAMETER_TYPE_PROPERTY);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == IS_MANDATORY_PROPERTY) {
            if (get) {
                return this.isMandatory();
            }
            this.setIsMandatory(value);
            return false;
        }
        if (property == IS_VARIADIC_PROPERTY) {
            if (get) {
                return this.isVariadic();
            }
            this.setIsVariadic(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == PARAMETER_NAME_PROPERTY) {
            if (get) {
                return this.getParameterName();
            }
            this.setParameterName((Expression)child);
            return null;
        }
        if (property == PARAMETER_TYPE_PROPERTY) {
            if (get) {
                return this.getParameterType();
            }
            this.setParameterType((Expression)child);
            return null;
        }
        if (property == DEFAULT_VALUE_PROPERTY) {
            if (get) {
                return this.getDefaultValue();
            }
            this.setDefaultValue((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    public Identifier getParameterNameIdentifier() {
        Expression expression = this.parameterName;
        switch (this.parameterName.getType()) {
            case 48: {
                expression = ((Reference)expression).getExpression();
                if (expression.getType() != 60) {
                    throw new IllegalStateException();
                }
            }
            case 60: {
                Identifier variableName = (Identifier)((Variable)expression).getName();
                return variableName;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression name = ASTNode.copySubtree(target, this.getParameterName());
        Expression type = ASTNode.copySubtree(target, this.getParameterType());
        Expression value = ASTNode.copySubtree(target, this.getDefaultValue());
        boolean isMandatory = this.isMandatory();
        boolean isVariadic = this.isVariadic();
        FormalParameter result = new FormalParameter(this.getStart(), this.getEnd(), target, type, name, value, isMandatory, isVariadic);
        return result;
    }

    public final ITypeBinding resolveTypeBinding() {
        return this.ast.getBindingResolver().resolveTypeParameter(this);
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null && this.defaultValue.getLength() > 0;
    }
}

