/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.IBinding;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class Identifier
extends VariableBase {
    private String name;
    private boolean nullable;
    public static final SimplePropertyDescriptor NAME_PROPERTY = new SimplePropertyDescriptor(Identifier.class, "name", String.class, true);
    public static final SimplePropertyDescriptor NULLABLE_PROPERTY = new SimplePropertyDescriptor(Identifier.class, "nullable", Boolean.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<SimplePropertyDescriptor> list = new ArrayList<SimplePropertyDescriptor>(2);
        list.add(NAME_PROPERTY);
        list.add(NULLABLE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(list);
    }

    public Identifier(int start, int end, AST ast, String value) {
        super(start, end, ast);
        if (value == null) {
            throw new IllegalArgumentException();
        }
        value.intern();
        this.setName(value);
    }

    public Identifier(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<Identifier");
        this.appendInterval(buffer);
        buffer.append(" name='").append(this.name);
        if (this.isNullable()) {
            buffer.append(" nullable='").append(this.nullable);
        }
        buffer.append("'/>");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Identifier other = (Identifier)obj;
        return this.name == other.name && this.nullable == other.nullable;
    }

    @Override
    public int getType() {
        return 33;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    protected ASTNode clone0(AST target) {
        Identifier result = new Identifier(this.getStart(), this.getEnd(), target, this.getName());
        result.setNullable(this.isNullable());
        return result;
    }

    @Override
    protected List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((String)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    @Override
    boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == NULLABLE_PROPERTY) {
            if (get) {
                return this.isNullable();
            }
            this.setNullable(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    public final void setName(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(NAME_PROPERTY);
        this.name = value;
        this.postValueChange(NAME_PROPERTY);
    }

    public final void setNullable(boolean value) {
        this.preValueChange(NULLABLE_PROPERTY);
        this.nullable = value;
        this.postValueChange(NULLABLE_PROPERTY);
    }

    public final IBinding resolveBinding() {
        return this.ast.getBindingResolver().resolveName(this);
    }
}

