/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.KeywordsStrategy;
import org.eclipse.php.internal.core.language.keywords.PHPKeywords;
import org.eclipse.php.internal.core.util.text.TextSequence;

public class ClassKeywordsStrategy
extends KeywordsStrategy {
    private TextSequence statementText;

    public ClassKeywordsStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public ClassKeywordsStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        this.statementText = ((AbstractCompletionContext)context).getStatementText();
        super.apply(reporter);
    }

    @Override
    protected boolean filterKeyword(PHPKeywords.KeywordData keyword) {
        if (keyword.name.equals("array") && this.statementText.toString().indexOf("=") > 0) {
            return false;
        }
        if ((keyword.context & 1) == 0) {
            return true;
        }
        int i = this.statementText.toString().indexOf(keyword.name);
        return i != -1 && (i == 0 || Character.isWhitespace(this.statementText.charAt(i - 1)) && this.statementText.length() > i + keyword.name.length() && Character.isWhitespace(this.statementText.charAt(i + keyword.name.length())));
    }
}

