/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.IPHPCompletionRequestor;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;
import org.eclipse.php.internal.core.model.PhpModelAccess;

public class TypeInStringStrategy
extends AbstractCompletionStrategy {
    private static final String SUFFIX = "";
    protected static final IType[] EMPTY = new IType[0];
    protected int trueFlag;
    protected int falseFlag;

    public TypeInStringStrategy(ICompletionContext context) {
        super(context);
    }

    protected int getExtraInfo() {
        return 651;
    }

    @Override
    public void apply(ICompletionReporter reporter) throws Exception {
        ICompletionContext context = this.getContext();
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        if (abstractContext.getCompletionRequestor() instanceof IPHPCompletionRequestor) {
            IPHPCompletionRequestor phpCompletionRequestor = (IPHPCompletionRequestor)abstractContext.getCompletionRequestor();
            if (phpCompletionRequestor.filter(2)) {
                return;
            }
            if (!phpCompletionRequestor.isExplicit()) {
                return;
            }
        }
        if (StringUtils.isBlank((CharSequence)abstractContext.getPrefixWithoutProcessing())) {
            return;
        }
        ISourceRange replacementRange = this.getReplacementRange(abstractContext);
        IType[] types = this.getTypes(abstractContext);
        int extraInfo = this.getExtraInfo();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            reporter.reportType(type, SUFFIX, replacementRange, extraInfo);
            ++n2;
        }
    }

    protected IType[] getTypes(AbstractCompletionContext context) throws BadLocationException {
        String prefix = context.getPrefix();
        if (prefix.startsWith("$")) {
            return EMPTY;
        }
        IDLTKSearchScope scope = this.createSearchScope();
        if (context.getCompletionRequestor().isContextInformationMode()) {
            return PhpModelAccess.getDefault().findTypes(prefix, ISearchEngine.MatchRule.EXACT, this.trueFlag, this.falseFlag, scope, null);
        }
        LinkedList<IType> result = new LinkedList<IType>();
        if (prefix.contains("\\")) {
            if ((0x800 & this.falseFlag) == 0) {
                result.addAll(CodeAssistUtils.removeDuplicatedElements((IModelElement[])PhpModelAccess.getDefault().findNamespaces(null, prefix, ISearchEngine.MatchRule.PREFIX, this.trueFlag, this.falseFlag, scope, null)));
            }
            result.addAll(Arrays.asList(PhpModelAccess.getDefault().findTypes(prefix, ISearchEngine.MatchRule.PREFIX, this.trueFlag, this.falseFlag, scope, null)));
            result.addAll(Arrays.asList(PhpModelAccess.getDefault().findTypes(prefix, SUFFIX, ISearchEngine.MatchRule.PREFIX, this.trueFlag, this.falseFlag, scope, null)));
        } else {
            result.addAll(Arrays.asList(PhpModelAccess.getDefault().findTypes(null, prefix, ISearchEngine.MatchRule.PREFIX, this.trueFlag, this.falseFlag, scope, null)));
            if ((0x800 & this.falseFlag) == 0) {
                result.addAll(CodeAssistUtils.removeDuplicatedElements((IModelElement[])PhpModelAccess.getDefault().findNamespaces(null, prefix, ISearchEngine.MatchRule.PREFIX, this.trueFlag, this.falseFlag, scope, null)));
            }
        }
        return result.toArray(new IType[result.size()]);
    }
}

