/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.preferences;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.IPHPExesListener;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPExesEvent;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class PHPexes {
    private static final String NULL_PLACE_HOLDER = "null";
    private static final String SEPARATOR_FOR_PHPVERSION = "/";
    private static final String DEFAULT_ATTRIBUTE = "default";
    private static final String EXTENSION_POINT_NAME = "phpExe";
    private static final String ID_ATTRIBUTE = "id";
    private static final String LOCATION_ATTRIBUTE = "location";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DEBUGGER_ID_ATTRIBUTE = "debuggerID";
    private static final String PHPEXE_TAG = "phpExe";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    public static final String SEPARATOR = ";";
    private static final String VERSION_ATTRIBUTE = "version";
    public static final String ZEND_DEBUGGER_ID = "org.eclipse.php.debug.core.zendDebugger";
    private static Object lock = new Object();
    private static PHPexes instance;
    private HashMap<String, HashMap<String, PHPexeItem>> items = new HashMap();
    private HashMap<PHPVersion, PHPexeItem> defaultItemsForPHPVersion = new HashMap();
    private final LinkedList<IPHPExesListener> listeners = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PHPexes getInstance() {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                instance = new PHPexes();
            }
            return instance;
        }
    }

    private PHPexes() {
        this.load();
    }

    public static void changePermissions(File file) {
        LocalFile localFile;
        IFileInfo info;
        if (!Platform.getOS().equals("win32") && !(info = (localFile = new LocalFile(file)).fetchInfo()).getAttribute(4)) {
            info.setAttribute(4, true);
            try {
                localFile.putInfo(info, 1024, null);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }

    public void addItem(PHPexeItem item) {
        if (!this.hasItems()) {
            this.setDefaultItem(item);
        }
        this.storeItem(item);
    }

    private void storeItem(PHPexeItem item) {
        String debuggerId = item.getDebuggerID();
        HashMap<String, PHPexeItem> map = this.items.get(debuggerId);
        if (map == null) {
            map = new HashMap();
            this.items.put(debuggerId, map);
        }
        map.put(item.getName(), item);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            PHPExesEvent phpExesEvent = new PHPExesEvent(item);
            ((IPHPExesListener)iter.next()).phpExeAdded(phpExesEvent);
        }
    }

    public void updateItem(PHPexeItem original, PHPexeItem copy) {
        String debuggerID = original.getDebuggerID();
        HashMap<String, PHPexeItem> exes = this.items.get(debuggerID);
        if (exes != null) {
            exes.remove(original.getName());
        }
        boolean updateDefault = false;
        if (original.isDefault() && !original.getName().equals(copy.getName())) {
            updateDefault = true;
        }
        original.setName(copy.getName());
        original.setExecutable(copy.getExecutable());
        original.setINILocation(copy.getINILocation());
        original.setDebuggerID(copy.getDebuggerID());
        original.setSapiType(copy.getSapiType());
        original.setLoadDefaultINI(copy.isLoadDefaultINI());
        original.setVersion(copy.getVersion());
        debuggerID = original.getDebuggerID();
        exes = this.items.get(debuggerID);
        if (exes == null) {
            exes = new HashMap();
            this.items.put(debuggerID, exes);
        }
        exes.put(original.getName(), original);
        if (updateDefault) {
            this.setDefaultItem(original);
        }
    }

    public PHPexeItem getDefaultItem() {
        return PHPDebugPlugin.getWorkspaceDefaultExe();
    }

    public boolean hasItems(String debuggerId) {
        HashMap<String, PHPexeItem> map = this.items.get(debuggerId);
        return map != null && map.size() > 0;
    }

    public boolean hasItems() {
        return this.getAllItems().length > 0;
    }

    public PHPexeItem[] getEditableItems() {
        Set<String> installedDebuggers = PHPDebuggersRegistry.getDebuggersIds();
        ArrayList<PHPexeItem> list = new ArrayList<PHPexeItem>();
        for (String debuggerId : installedDebuggers) {
            HashMap<String, PHPexeItem> installedExes = this.items.get(debuggerId);
            if (installedExes == null) continue;
            for (Map.Entry<String, PHPexeItem> entry : installedExes.entrySet()) {
                PHPexeItem exeItem = entry.getValue();
                if (!exeItem.isEditable()) continue;
                list.add(exeItem);
            }
        }
        return list.toArray(new PHPexeItem[list.size()]);
    }

    public PHPexeItem getItem(String debuggerId, String name) {
        HashMap<String, PHPexeItem> map = this.items.get(debuggerId);
        if (map == null) {
            return null;
        }
        return map.get(name);
    }

    public PHPexeItem getItem(String name) {
        for (String debuggerId : this.items.keySet()) {
            PHPexeItem item;
            HashMap<String, PHPexeItem> map = this.items.get(debuggerId);
            if (map == null || (item = map.get(name)) == null) continue;
            return item;
        }
        return null;
    }

    public PHPexeItem findItem(String id) {
        for (String debuggerId : this.items.keySet()) {
            HashMap<String, PHPexeItem> map = this.items.get(debuggerId);
            if (map == null) continue;
            for (PHPexeItem value : map.values()) {
                if (!value.getUniqueId().equals(id)) continue;
                return value;
            }
        }
        return null;
    }

    public PHPexeItem getPHP54Item() {
        for (String debuggerId : this.items.keySet()) {
            HashMap<String, PHPexeItem> map = this.items.get(debuggerId);
            if (map == null) continue;
            for (PHPexeItem item : map.values()) {
                if (item == null || item.getVersion().compareTo("5.4.0") < 0) continue;
                return item;
            }
        }
        return null;
    }

    public List<PHPexeItem> getPHP54Items() {
        ArrayList<PHPexeItem> result = new ArrayList<PHPexeItem>();
        for (String debuggerId : this.items.keySet()) {
            HashMap<String, PHPexeItem> map = this.items.get(debuggerId);
            if (map == null) continue;
            for (PHPexeItem item : map.values()) {
                if (item == null || item.getVersion().compareTo("5.4.0") < 0) continue;
                result.add(item);
            }
        }
        return result;
    }

    public PHPexeItem getItemForFile(String exeFilePath, String iniFilePath) {
        Set<String> installedDebuggers = PHPDebuggersRegistry.getDebuggersIds();
        for (String debuggerId : installedDebuggers) {
            HashMap<String, PHPexeItem> installedExes = this.items.get(debuggerId);
            if (installedExes == null) continue;
            for (Map.Entry<String, PHPexeItem> entry : installedExes.entrySet()) {
                PHPexeItem exeItem = entry.getValue();
                boolean iniEquals = true;
                if (iniFilePath == null) {
                    iniEquals = exeItem.getINILocation() == null;
                } else {
                    boolean bl = iniEquals = exeItem.getINILocation() == null ? iniFilePath.equals("") : iniFilePath.equals(exeItem.getINILocation().toString());
                }
                if (!iniEquals || !exeFilePath.equals(exeItem.getExecutable().toString())) continue;
                return exeItem;
            }
        }
        return null;
    }

    public PHPexeItem[] getItems(String debuggerId) {
        HashMap<String, PHPexeItem> installedExes = this.items.get(debuggerId);
        if (installedExes == null) {
            return null;
        }
        PHPexeItem[] retItems = new PHPexeItem[installedExes.size()];
        return installedExes.values().toArray(retItems);
    }

    public PHPexeItem[] getAllItems() {
        ArrayList<PHPexeItem> allItems = new ArrayList<PHPexeItem>();
        Set<String> debuggers = this.items.keySet();
        for (String debugger : debuggers) {
            HashMap<String, PHPexeItem> debuggerItems = this.items.get(debugger);
            if (debuggerItems == null) continue;
            Collection<PHPexeItem> exeItems = debuggerItems.values();
            for (PHPexeItem item : exeItems) {
                allItems.add(item);
            }
        }
        return allItems.toArray(new PHPexeItem[allItems.size()]);
    }

    public PHPexeItem[] getCLIItems() {
        PHPexeItem[] allItems;
        ArrayList<PHPexeItem> cliItems = new ArrayList<PHPexeItem>();
        PHPexeItem[] pHPexeItemArray = allItems = this.getAllItems();
        int n = allItems.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem item = pHPexeItemArray[n2];
            if (item.getSapiType() != null && "CLI".equals(item.getSapiType())) {
                cliItems.add(item);
            }
            ++n2;
        }
        return cliItems.toArray(new PHPexeItem[cliItems.size()]);
    }

    private void load() {
        String[] defaultItemForPHPVersions;
        this.items = new HashMap();
        String namesString = Platform.getPreferencesService().getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.INSTALLED_PHP_NAMES, null, null);
        if (namesString == null) {
            namesString = "";
        }
        String[] names = namesString.length() > 0 ? namesString.split(SEPARATOR) : new String[]{};
        String locationsString = Platform.getPreferencesService().getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.INSTALLED_PHP_LOCATIONS, null, null);
        if (locationsString == null) {
            locationsString = "";
        }
        String[] phpExecutablesLocations = locationsString.length() > 0 ? locationsString.split(SEPARATOR) : new String[]{};
        String inisString = Platform.getPreferencesService().getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.INSTALLED_PHP_INIS, null, null);
        if (inisString == null) {
            inisString = "";
        }
        String[] phpIniLocations = inisString.length() > 0 ? inisString.split(SEPARATOR) : new String[phpExecutablesLocations.length];
        String loadDefaultInisString = Platform.getPreferencesService().getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.INSTALLED_PHP_LOAD_DEFAULT_INIS, null, null);
        if (loadDefaultInisString == null) {
            loadDefaultInisString = "";
        }
        String[] loadDefaultInis = loadDefaultInisString.length() > 0 ? loadDefaultInisString.split(SEPARATOR) : new String[phpExecutablesLocations.length];
        String uniqueIdsString = Platform.getPreferencesService().getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.INSTALLED_PHP_UNIQUE_IDS, null, null);
        if (uniqueIdsString == null) {
            uniqueIdsString = "";
        }
        String[] phpExecutablesUniqueIds = uniqueIdsString.length() > 0 ? uniqueIdsString.split(SEPARATOR) : new String[]{};
        String debuggersString = Platform.getPreferencesService().getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.INSTALLED_PHP_DEBUGGERS, null, null);
        if (debuggersString == null) {
            debuggersString = "";
        }
        String[] debuggers = debuggersString.length() > 0 ? debuggersString.split(SEPARATOR) : new String[]{};
        String defaultItemForPHPVersionString = Platform.getPreferencesService().getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.INSTALLED_PHP_DEFAULT_FOR_VERSIONS, null, null);
        if (defaultItemForPHPVersionString == null) {
            defaultItemForPHPVersionString = "";
        }
        String[] stringArray = defaultItemForPHPVersions = defaultItemForPHPVersionString.length() > 0 ? defaultItemForPHPVersionString.split(SEPARATOR) : new String[]{};
        assert (names.length == phpExecutablesLocations.length);
        int i = 0;
        while (i < phpExecutablesLocations.length) {
            boolean filterItem;
            String iniLocation;
            String string = iniLocation = NULL_PLACE_HOLDER.equals(phpIniLocations[i]) ? null : phpIniLocations[i];
            if (names.length <= i || debuggers.length <= i) break;
            final PHPexeItem item = new PHPexeItem(names[i], phpExecutablesLocations[i], iniLocation, debuggers[i], loadDefaultInis[i] != null && loadDefaultInis[i].equals(TRUE));
            if (phpExecutablesUniqueIds.length != 0) {
                item.setUniqueId(phpExecutablesUniqueIds[i]);
            }
            if (defaultItemForPHPVersions.length == phpExecutablesLocations.length && !NULL_PLACE_HOLDER.equals(defaultItemForPHPVersions[i])) {
                String[] phpVersions = defaultItemForPHPVersions[i].length() > 0 ? defaultItemForPHPVersions[i].split(SEPARATOR_FOR_PHPVERSION) : new String[]{};
                int j = 0;
                while (j < phpVersions.length) {
                    PHPVersion phpVersion = PHPVersion.byAlias((String)phpVersions[j]);
                    if (phpVersion != null) {
                        item.addPHPVersionToDefaultList(phpVersion);
                        this.defaultItemsForPHPVersion.put(phpVersion, item);
                    }
                    ++j;
                }
            }
            if (item.getExecutable() != null && !(filterItem = WorkbenchActivityHelper.filterItem((Object)new IPluginContribution(){

                public String getLocalId() {
                    return item.getDebuggerID();
                }

                public String getPluginId() {
                    return "org.eclipse.php.debug.core";
                }
            }))) {
                this.storeItem(item);
            }
            ++i;
        }
        this.loadExtensions();
        new PHPexesUpgrade().upgrade();
    }

    private void loadExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(PHPDebugPlugin.getID(), "phpExe");
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if ("phpExe".equals(element.getName())) {
                    try {
                        String id = element.getAttribute(ID_ATTRIBUTE);
                        String name = element.getAttribute(NAME_ATTRIBUTE);
                        String location = this.substitudeVariables(element.getAttribute(LOCATION_ATTRIBUTE));
                        String version = element.getAttribute(VERSION_ATTRIBUTE);
                        String debuggerID = element.getAttribute(DEBUGGER_ID_ATTRIBUTE);
                        if (debuggerID == null || debuggerID.equals("")) {
                            debuggerID = "org.eclipse.php.debug.core.noneDebugger";
                        }
                        boolean isDefault = TRUE.equalsIgnoreCase(element.getAttribute(DEFAULT_ATTRIBUTE));
                        if (isWindows) {
                            location = String.valueOf(location) + ".exe";
                        }
                        String pluginId = element.getDeclaringExtension().getNamespaceIdentifier();
                        final String finalDebuggerID = debuggerID;
                        boolean filterItem = WorkbenchActivityHelper.filterItem((Object)new IPluginContribution(){

                            public String getLocalId() {
                                return finalDebuggerID;
                            }

                            public String getPluginId() {
                                return "org.eclipse.php.debug.core";
                            }
                        });
                        if (filterItem) break block11;
                        boolean itemFound = false;
                        File file = this.getFileFromLocation(location, pluginId);
                        if (file != null && file.exists()) {
                            String defaultExeName;
                            PHPexeItem newItem = new PHPexeItem(name, file, null, debuggerID, false);
                            if (newItem == null || newItem.getExecutable() == null || newItem.getVersion() == null) break block11;
                            if (version != null) {
                                newItem.setVersion(version);
                            }
                            String uniqueID = id != null ? id : "php-extension-exe-" + file.getPath().toString();
                            newItem.setUniqueId(uniqueID);
                            this.storeItem(newItem);
                            if (isDefault && ((defaultExeName = InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core").get(PHPDebugCorePreferenceNames.DEFAULT_PHP, null)) == null || this.getItem(defaultExeName) == null)) {
                                this.setDefaultItem(newItem);
                            }
                            itemFound = true;
                        }
                        if (!itemFound) {
                            PHPDebugPlugin.log((IStatus)new Status(1, PHPDebugPlugin.getID(), 1001, "PHP executable " + location + " not found neither in plugin " + pluginId + " nor in fragments attached to it", null));
                        }
                    }
                    catch (IOException | CoreException e) {
                        PHPDebugPlugin.log(e);
                    }
                }
            }
            ++n2;
        }
    }

    public void removeItem(PHPexeItem item) {
        String debuggerID = item.getDebuggerID();
        HashMap<String, PHPexeItem> exes = this.items.get(debuggerID);
        PHPexeItem removedItem = null;
        if (exes != null) {
            removedItem = exes.remove(item.getName());
        }
        if (removedItem != null && removedItem.isDefault()) {
            this.detectDefaultItem();
        }
        if (this.getAllItems().length == 0) {
            this.setDefaultItem(null);
        }
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            PHPExesEvent phpExesEvent = new PHPExesEvent(item);
            ((IPHPExesListener)iter.next()).phpExeRemoved(phpExesEvent);
        }
    }

    public void setDefaultItem(PHPexeItem defaultItem) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core");
        if (defaultItem != null) {
            preferences.put(PHPDebugCorePreferenceNames.DEFAULT_PHP, defaultItem.getName());
        } else {
            preferences.remove(PHPDebugCorePreferenceNames.DEFAULT_PHP);
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
    }

    private void detectDefaultItem() {
        PHPexeItem[] allItems = this.getAllItems();
        Comparator<PHPexeItem> sorter = new Comparator<PHPexeItem>(){

            @Override
            public int compare(PHPexeItem a, PHPexeItem b) {
                return b.getVersion().compareTo(a.getVersion());
            }
        };
        Arrays.sort(allItems, sorter);
        if (allItems.length > 0) {
            this.setDefaultItem(allItems[0]);
        }
    }

    public void save() {
        IEclipsePreferences prefs = PHPDebugPlugin.getInstancePreferences();
        PHPexeItem[] phpItems = this.getEditableItems();
        StringBuilder locationsString = new StringBuilder();
        StringBuilder inisString = new StringBuilder();
        StringBuilder namesString = new StringBuilder();
        StringBuilder uniqueIdsString = new StringBuilder();
        StringBuilder debuggersString = new StringBuilder();
        StringBuilder defaultItemForPHPVersionString = new StringBuilder();
        StringBuilder loadIniDefaultString = new StringBuilder();
        int i = 0;
        while (i < phpItems.length) {
            PHPexeItem item = phpItems[i];
            if (i > 0) {
                locationsString.append(SEPARATOR);
                inisString.append(SEPARATOR);
                namesString.append(SEPARATOR);
                uniqueIdsString.append(SEPARATOR);
                debuggersString.append(SEPARATOR);
                defaultItemForPHPVersionString.append(SEPARATOR);
                loadIniDefaultString.append(SEPARATOR);
            }
            locationsString.append(item.getExecutable().toString());
            inisString.append(item.getINILocation() != null ? item.getINILocation().toString() : NULL_PLACE_HOLDER);
            namesString.append(item.getName());
            uniqueIdsString.append(item.getUniqueId());
            debuggersString.append(item.getDebuggerID());
            loadIniDefaultString.append(item.isLoadDefaultINI() ? TRUE : FALSE);
            if (item.geDefaultForPHPVersionSize() > 0) {
                int j = 0;
                while (j < item.geDefaultForPHPVersionSize()) {
                    if (j > 0) {
                        defaultItemForPHPVersionString.append(SEPARATOR_FOR_PHPVERSION);
                    }
                    defaultItemForPHPVersionString.append(item.getPHPVersionAtDefaultList(j).getAlias());
                    ++j;
                }
            } else {
                defaultItemForPHPVersionString.append(NULL_PLACE_HOLDER);
            }
            ++i;
        }
        prefs.put(PHPDebugCorePreferenceNames.INSTALLED_PHP_NAMES, namesString.toString());
        prefs.put(PHPDebugCorePreferenceNames.INSTALLED_PHP_UNIQUE_IDS, uniqueIdsString.toString());
        prefs.put(PHPDebugCorePreferenceNames.INSTALLED_PHP_LOCATIONS, locationsString.toString());
        prefs.put(PHPDebugCorePreferenceNames.INSTALLED_PHP_INIS, inisString.toString());
        prefs.put(PHPDebugCorePreferenceNames.INSTALLED_PHP_DEBUGGERS, debuggersString.toString());
        prefs.put(PHPDebugCorePreferenceNames.INSTALLED_PHP_DEFAULT_FOR_VERSIONS, defaultItemForPHPVersionString.toString());
        prefs.put(PHPDebugCorePreferenceNames.INSTALLED_PHP_LOAD_DEFAULT_INIS, loadIniDefaultString.toString());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
    }

    public void addPHPExesListener(IPHPExesListener listener) {
        this.listeners.add(listener);
    }

    public void removePHPExesListener(IPHPExesListener listener) {
        this.listeners.remove(listener);
    }

    public void setItemDefaultForPHPVersion(PHPexeItem phPexeItem, PHPVersion phpVersion) {
        PHPexeItem oldItem = this.defaultItemsForPHPVersion.get(phpVersion);
        if (oldItem != null) {
            oldItem.removePHPVersionToDefaultList(phpVersion);
        }
        phPexeItem.addPHPVersionToDefaultList(phpVersion);
        this.defaultItemsForPHPVersion.put(phpVersion, phPexeItem);
    }

    public PHPexeItem getDefaultItemForPHPVersion(PHPVersion phpVersion) {
        return this.defaultItemsForPHPVersion.get(phpVersion);
    }

    public HashMap<PHPVersion, PHPexeItem> getDefaultItemsForPHPVersion() {
        return this.defaultItemsForPHPVersion;
    }

    public PHPexeItem[] getCompatibleItems(PHPexeItem[] allItems, PHPVersion version) {
        String versionNumber = version.getAlias().substring(3);
        ArrayList<PHPexeItem> list = new ArrayList<PHPexeItem>();
        int i = 0;
        while (i < allItems.length) {
            if (allItems[i].getVersion() != null && allItems[i].getVersion().compareTo(versionNumber) >= 0) {
                list.add(allItems[i]);
            }
            ++i;
        }
        PHPexeItem[] result = list.toArray(new PHPexeItem[list.size()]);
        return result;
    }

    private String substitudeVariables(String expression) throws CoreException {
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(expression, true);
    }

    private File getFileFromLocation(String location, String pluginId) throws IOException {
        if (Paths.get(location, new String[0]).isAbsolute()) {
            return new File(location);
        }
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)pluginId), (IPath)new Path(location), null);
        if (url != null) {
            url = FileLocator.resolve((URL)url);
            String filename = url.getFile();
            return new File(filename);
        }
        return null;
    }

    private class PHPexesUpgrade {
        private PHPexesUpgrade() {
        }

        private void upgrade() {
            String uniqueIds = Platform.getPreferencesService().getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.INSTALLED_PHP_UNIQUE_IDS, null, null);
            PHPexeItem[] userItems = PHPexes.this.getEditableItems();
            if (userItems.length == 0) {
                return;
            }
            if (uniqueIds == null || uniqueIds.isEmpty()) {
                PHPexes.this.save();
            }
        }
    }
}

