/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.debugger.DebuggerSettingsManager;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettings;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsListener;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.XDebugDebuggerSettingsUtil;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DBGpProxyHandler {
    private boolean registered = false;
    private String currentIdeKey = null;
    private String proxyHost = "";
    private int proxyPort = 9001;
    private int idePort = -1;
    private int errorCode = 0;
    private String errorMsg = "";
    private boolean multisession = false;
    private String ownerId;
    private IDebuggerSettingsListener ownerSettingsListener = new SettingsListener();
    private static final int DEFAULT_PROXY_PORT = 9001;
    private static final int PROXY_CONNECT_TIMEOUT = 3000;

    public DBGpProxyHandler(String ownerId) {
        this.ownerId = ownerId;
        DebuggerSettingsManager.INSTANCE.addSettingsListener(this.ownerSettingsListener);
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public boolean registerWithProxy() {
        DBGpResponse resp;
        if (!this.registered && (resp = this.sendcmd("proxyinit -p " + this.idePort + " -k " + this.currentIdeKey + " -m " + (this.multisession ? "1" : "0"))) != null) {
            if (resp.getType() == 4 && resp.getErrorCode() == 0) {
                this.registered = true;
            } else {
                this.errorCode = resp.getErrorCode();
                this.errorMsg = resp.getErrorMessage();
            }
        }
        return this.registered;
    }

    public void unregister() {
        if (this.registered) {
            DBGpResponse resp = this.sendcmd("proxystop -k " + this.currentIdeKey);
            this.registered = false;
            if (resp == null) {
                return;
            }
            String isOk = DBGpResponse.getAttribute(resp.getParentNode(), "success");
            if (isOk == null || !isOk.equals("1")) {
                DBGpLogger.logWarning("Unexpected response from proxystop. ErrorCode=" + resp.getErrorCode() + ". msg=" + resp.getErrorMessage(), this, null);
            }
        }
    }

    public void dispose() {
        DebuggerSettingsManager.INSTANCE.removeSettingsListener(this.ownerSettingsListener);
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void configure() {
        if (!this.useProxy()) {
            this.unregister();
        } else {
            String proxy;
            int idePort = XDebugDebuggerSettingsUtil.getDebugPort(this.getOwnerId());
            String ideKey = XDebugDebuggerSettingsUtil.getProxyIdeKey(this.getOwnerId());
            boolean multisession = XDebugPreferenceMgr.useMultiSession();
            String proxyHost = proxy = XDebugDebuggerSettingsUtil.getProxyAddress(this.getOwnerId());
            int proxyPort = 9001;
            int split = proxy.indexOf(58);
            if (split != -1) {
                proxyHost = proxy.substring(0, split);
                if (split + 1 < proxy.length()) {
                    String portStr = proxy.substring(split + 1);
                    try {
                        proxyPort = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if (proxyPort == idePort) {
                this.displayErrorMessage(PHPDebugCoreMessages.XDebug_DBGpProxyHandler_0);
            } else {
                this.setProxyInfo(proxyHost, proxyPort, ideKey, idePort, multisession);
                if (XDebugPreferenceMgr.getAcceptRemoteSession() != XDebugPreferenceMgr.AcceptRemoteSession.off) {
                    Job job = new Job(PHPDebugCoreMessages.DBGpProxyConnection_Registering_DBGp_proxy){

                        protected IStatus run(IProgressMonitor monitor) {
                            if (!DBGpProxyHandler.this.registerWithProxy()) {
                                DBGpProxyHandler.this.displayErrorMessage(String.valueOf(PHPDebugCoreMessages.XDebug_DBGpProxyHandler_1) + DBGpProxyHandler.this.getErrorMsg());
                                XDebugPreferenceMgr.setUseProxy(false);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }
        }
    }

    private void setProxyInfo(String host, int port, String idekey, int listeningPort, boolean multisession) {
        if (!host.equalsIgnoreCase(this.proxyHost) || port != this.proxyPort || !idekey.equals(this.currentIdeKey) || this.idePort != listeningPort || this.multisession != multisession) {
            this.unregister();
            this.proxyHost = host;
            this.proxyPort = port;
            this.idePort = listeningPort;
            this.currentIdeKey = idekey;
            this.multisession = multisession;
        }
    }

    public boolean useProxy() {
        return XDebugDebuggerSettingsUtil.getProxyEnabled(this.getOwnerId());
    }

    private DBGpResponse sendcmd(String cmd) {
        DBGpResponse dbgpResp = null;
        try {
            Socket s = new Socket();
            InetSocketAddress server = new InetSocketAddress(this.proxyHost, this.proxyPort);
            InetSocketAddress local = new InetSocketAddress(0);
            s.bind(local);
            s.connect(server, 3000);
            InputStream is = s.getInputStream();
            OutputStream os = s.getOutputStream();
            if (DBGpLogger.debugCmd()) {
                DBGpLogger.debug("cmd: " + cmd);
            }
            os.write(cmd.getBytes("ASCII"));
            os.flush();
            byte[] resp = this.readResponse(is);
            dbgpResp = new DBGpResponse();
            dbgpResp.parseResponse(resp);
            s.shutdownInput();
            s.shutdownOutput();
            s.close();
            return dbgpResp;
        }
        catch (IOException ioe) {
            if (dbgpResp == null) {
                this.errorCode = 9999;
                if (ioe instanceof EOFException) {
                    this.errorMsg = PHPDebugCoreMessages.XDebug_DBGpProxyHandler_2;
                } else {
                    this.errorMsg = ioe.getMessage();
                    if (this.errorMsg == null) {
                        this.errorMsg = ioe.getClass().getName();
                    }
                }
            }
            return dbgpResp;
        }
    }

    private byte[] readResponse(InputStream is) throws IOException {
        int b;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((b = is.read()) != -1) {
            baos.write(b);
        }
        byte[] byteArray = baos.toByteArray();
        if (DBGpLogger.debugResp()) {
            DBGpLogger.debug("Response: " + new String(byteArray, "ASCII"));
        }
        return byteArray;
    }

    public String getCurrentIdeKey() {
        return this.currentIdeKey;
    }

    private void displayErrorMessage(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.XDebug_DBGpProxyHandler_3, (String)message);
            }
        });
    }

    private class SettingsListener
    implements IDebuggerSettingsListener {
        private SettingsListener() {
        }

        @Override
        public void settingsAdded(IDebuggerSettings settings) {
        }

        @Override
        public void settingsRemoved(IDebuggerSettings settings) {
        }

        @Override
        public void settingsChanged(PropertyChangeEvent[] events) {
            boolean configure = false;
            PropertyChangeEvent[] propertyChangeEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyChangeEvent event = propertyChangeEventArray[n2];
                IDebuggerSettings source = (IDebuggerSettings)event.getSource();
                if (source.getOwnerId().equals(DBGpProxyHandler.this.getOwnerId())) {
                    configure = true;
                }
                ++n2;
            }
            if (configure) {
                DBGpProxyHandler.this.configure();
            }
        }
    }
}

