/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.core.tests;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.formatter.core.tests.FormatterTests;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.ui.autoEdit.MainAutoEditStrategy;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class FormatterLinuxAutoEditTests
extends FormatterTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    protected static final char OFFSET_CHAR = '|';
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/formatter-autoedit/php5"});
    }

    public FormatterLinuxAutoEditTests(PHPVersion version, String[] fileNames) throws Exception {
        super(version, fileNames);
    }

    @Override
    @Test
    public void formatter(String fileName) throws Exception {
        IFile file = (IFile)this.files.get(fileName);
        PdttFile pdttFile = (PdttFile)this.pdttFiles.get(fileName);
        IStructuredDocument document = StructuredModelManager.getModelManager().getModelForRead(file).getStructuredDocument();
        String data = document.get();
        int offset = data.lastIndexOf(124);
        if (offset == -1) {
            throw new IllegalArgumentException(String.valueOf(data) + ",offset character is not set");
        }
        data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
        document.set(data);
        MainAutoEditStrategy indentLineAutoEditStrategy = new MainAutoEditStrategy();
        DocumentCommand cmd = new DocumentCommand(){};
        cmd.offset = offset;
        cmd.length = 0;
        cmd.text = pdttFile.getOther() != null ? pdttFile.getOther().replaceAll("\r\n", "\n") : "\n";
        cmd.doit = true;
        cmd.shiftsCaret = true;
        cmd.caretOffset = -1;
        indentLineAutoEditStrategy.customizeDocumentCommand((IDocument)document, cmd);
        document.replace(cmd.offset, cmd.length, cmd.text);
        PDTTUtils.assertContents((String)pdttFile.getExpected().replaceAll("\r\n", "\n"), (String)document.get());
    }
}

