/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.move;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceProcessors;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.move.MoveDelegate;

public class PHPMoveProcessor
extends MoveProcessor {
    private IContainer fResourceDestination;
    private IResource[] fSourceResources = new IResource[0];
    private boolean fUpdateReferences;
    private MoveDelegate fDelegate = new MoveDelegate(this);

    public PHPMoveProcessor(IResource[] resources) {
        this.fSourceResources = resources;
    }

    public PHPMoveProcessor(IStructuredSelection selection) {
        this(PHPMoveProcessor.getResources(selection));
    }

    public PHPMoveProcessor(IResource resource) {
        this(new IResource[]{resource});
    }

    public static IResource[] getResources(IStructuredSelection sel) {
        ArrayList<Object> resources = new ArrayList<Object>(sel.size());
        for (Object next : sel) {
            IAdapterManager adapterManager;
            ResourceMapping mapping;
            if (next instanceof IResource) {
                resources.add(next);
                continue;
            }
            if (next instanceof IAdaptable) {
                Object resource = ((IAdaptable)next).getAdapter(IResource.class);
                if (resource == null) continue;
                resources.add(resource);
                continue;
            }
            if (next == null || (mapping = (ResourceMapping)(adapterManager = Platform.getAdapterManager()).getAdapter(next, ResourceMapping.class)) == null) continue;
            ResourceTraversal[] traversals = null;
            try {
                traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
            if (traversals == null) continue;
            int i = 0;
            while (i < traversals.length) {
                IResource[] traversalResources = traversals[i].getResources();
                if (traversalResources != null) {
                    int j = 0;
                    while (j < traversalResources.length) {
                        resources.add(traversalResources[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws OperationCanceledException {
        return this.fDelegate.checkInitialConditions();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return this.fDelegate.checkFinalConditions();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange rootChange = new CompositeChange(this.getProcessorName());
        return this.fDelegate.createChange(pm, rootChange);
    }

    public Object[] getElements() {
        return new Object[]{this.fSourceResources};
    }

    public String getIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getProcessorName() {
        return PhpRefactoringCoreMessages.getString("PHPMoveProcessor.0");
    }

    public boolean isApplicable() {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) {
        try {
            String[] affectedNatures = ResourceProcessors.computeAffectedNatures((IResource[])this.fSourceResources);
            MoveArguments arguments = new MoveArguments((Object)this.fResourceDestination, this.getUpdateReferences());
            ArrayList<IResource> resourceList = new ArrayList<IResource>();
            IResource[] iResourceArray = this.fSourceResources;
            int n = this.fSourceResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource fResource = iResourceArray[n2];
                resourceList.add(fResource);
                ++n2;
            }
            return ParticipantManager.loadMoveParticipants((RefactoringStatus)status, (RefactoringProcessor)this, resourceList, (MoveArguments)arguments, null, (String[])affectedNatures, (SharableParticipants)sharedParticipants);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new RefactoringParticipant[0];
        }
    }

    public RefactoringStatus setDestination(IContainer destination) {
        this.fResourceDestination = destination;
        return this.fDelegate.verifyDestination((IResource)destination);
    }

    public IContainer getDestination() {
        return this.fResourceDestination;
    }

    public IResource[] getSourceSelection() {
        return this.fSourceResources;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }
}

