/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.organizeIncludes;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.organizeIncludes.OrganizeIncludesProcessorDelegate;

public class OrganizeIncludesProcessor
extends RefactoringProcessor {
    Collection<IFile> files;

    public OrganizeIncludesProcessor(Collection<IFile> files) {
        this.files = Collections.unmodifiableCollection(files);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        return status;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (this.files.size() == 0) {
            status.addFatalError(PhpRefactoringCoreMessages.getString("OrganizeIncludesProcessor.Not_Applicable"));
        }
        return status;
    }

    public Change createChange(IProgressMonitor monitor) throws OperationCanceledException {
        CompositeChange rootChange = new CompositeChange(PhpRefactoringCoreMessages.getString("OrganizeIncludesProcessor.Organizing_Includes"));
        rootChange.markAsSynthetic();
        monitor.beginTask(PhpRefactoringCoreMessages.getString("OrganizeIncludesProcessor.Calculating"), this.files.size());
        for (IFile element : this.files) {
            if (monitor.isCanceled()) {
                return rootChange;
            }
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
            Change fileChange = this.createFileChange(element, (IProgressMonitor)subMonitor);
            if (fileChange == null) continue;
            rootChange.add(fileChange);
        }
        return rootChange;
    }

    private Change createFileChange(IFile file, IProgressMonitor monitor) {
        OrganizeIncludesProcessorDelegate delegate = new OrganizeIncludesProcessorDelegate(file);
        if (delegate.initializeModel()) {
            Change change = delegate.createChange(monitor);
            delegate.disposeModel();
            return change;
        }
        return null;
    }

    public Object[] getElements() {
        return this.files.toArray();
    }

    public String getIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getProcessorName() {
        return "Organize Includes Processor";
    }

    public boolean isApplicable() {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) {
        return new RefactoringParticipant[0];
    }
}

