/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.wizard;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.refactoring.core.rename.INameUpdating;
import org.eclipse.php.refactoring.core.rename.IReferenceUpdating;
import org.eclipse.php.refactoring.ui.PHPRefactoringUIMessages;
import org.eclipse.php.refactoring.ui.wizard.RenameInputWizardPage;
import org.eclipse.php.refactoring.ui.wizard.RenameRefactoringWizard;
import org.eclipse.php.refactoring.ui.wizard.RowLayouter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class RenameFileWizard
extends RenameRefactoringWizard {
    public RenameFileWizard(Refactoring refactoring) {
        super(refactoring, PHPRefactoringUIMessages.getString("RenameFileWizard.0"), PHPRefactoringUIMessages.getString("RenameGlobalVariableWizard_inputPageDescription"), null, null);
    }

    @Override
    protected RenameInputWizardPage createInputPage(String message, String initialSetting) {
        return new RenameInputWizardPage(message, null, true, initialSetting){
            private static final String UPDATE_REFERENCES = "updateReferences";
            private Button fUpdateReferences;
            private Button fUPdateClassName;

            @Override
            protected RefactoringStatus validateTextField(String text) {
                return RenameFileWizard.this.validateNewName(text);
            }

            @Override
            protected void addAdditionalOptions(Composite composite, RowLayouter layouter) {
                final IReferenceUpdating refactoring = (IReferenceUpdating)this.getRefactoring().getAdapter(IReferenceUpdating.class);
                String title = PHPRefactoringUIMessages.getString("RenameFileWizard.1");
                boolean defaultValue = this.getBooleanSetting(UPDATE_REFERENCES, refactoring.getUpdateReferences());
                this.fUpdateReferences = 1.createCheckbox(composite, title, defaultValue, layouter);
                this.fUpdateReferences.setSelection(true);
                refactoring.setUpdateRefernces(true);
                this.getRefactoringWizard().setForcePreviewReview(true);
                this.fUpdateReferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        refactoring.setUpdateRefernces(fUpdateReferences.getSelection());
                        this.updateForcePreview();
                    }
                });
                String updateClass = refactoring.getAttribute("org.eclipse.php.refactoring.core.rename.resource.needclassname");
                if (updateClass != null && Boolean.valueOf(updateClass).booleanValue()) {
                    defaultValue = true;
                    this.fUPdateClassName = 1.createCheckbox(composite, PHPRefactoringUIMessages.getString("RenameFileWizard.3"), defaultValue, layouter);
                    this.fUPdateClassName.setSelection(true);
                    refactoring.setAttribute("org.eclipse.php.refactoring.core.rename.resource.classname", Boolean.toString(this.fUPdateClassName.getSelection()));
                    this.getRefactoringWizard().setForcePreviewReview(true);
                    this.fUPdateClassName.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            refactoring.setAttribute("org.eclipse.php.refactoring.core.rename.resource.classname", Boolean.toString(fUPdateClassName.getSelection()));
                            this.updateForcePreview();
                        }
                    });
                }
            }

            @Override
            protected void updateForcePreview() {
                super.updateForcePreview();
                boolean forcePreview = false;
                Refactoring refactoring = this.getRefactoring();
                IReferenceUpdating refUpdate = (IReferenceUpdating)refactoring.getAdapter(IReferenceUpdating.class);
                if (refUpdate != null) {
                    forcePreview = refUpdate.getUpdateReferences();
                }
                this.getRefactoringWizard().setForcePreviewReview(forcePreview);
            }

            @Override
            public void dispose() {
                if (this.saveSettings()) {
                    this.saveBooleanSetting(UPDATE_REFERENCES, this.fUpdateReferences);
                }
                super.dispose();
            }
        };
    }

    @Override
    protected RefactoringStatus validateNewName(String newName) {
        INameUpdating ref = this.getNameUpdating();
        ref.setNewElementName(newName);
        ResourcesPlugin.getWorkspace().validateName(newName, 1);
        IStatus nameStatus = ResourcesPlugin.getWorkspace().validateName(newName, 1);
        if (!nameStatus.isOK()) {
            return RefactoringStatus.createFatalErrorStatus((String)nameStatus.getMessage());
        }
        return new RefactoringStatus();
    }
}

