/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.templates;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.templates.ScriptTemplateContext;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.codeassist.CompletionRequestorExtension;
import org.eclipse.php.internal.core.codeassist.contexts.ClassObjMemberContext;
import org.eclipse.php.internal.core.codeassist.contexts.GlobalStatementContext;
import org.eclipse.php.internal.core.codeassist.templates.CodeCompletionRequestor;
import org.eclipse.php.internal.core.codeassist.templates.contexts.GlobalMethodStatementContextForTemplate;
import org.eclipse.php.internal.core.codeassist.templates.contexts.GlobalStatementContextForTemplate;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.templates.Messages;

public class PhpTemplateVariables {
    private static ISourceModule getSourceModule(TemplateContext context) {
        return ((ScriptTemplateContext)context).getSourceModule();
    }

    private static String findUnusedName(Set<String> knownNames) {
        int base = 8;
        int counter = -1;
        int maxCounter = 2;
        String proposal = String.valueOf((char)(97 + base));
        while (knownNames.contains(proposal)) {
            if ((counter = (counter + 1) % maxCounter) == 0 && (base = (base + 1) % 26) == 8) {
                maxCounter = Integer.MAX_VALUE;
            }
            proposal = String.valueOf((char)(97 + base));
            if (counter <= 0) continue;
            proposal = String.valueOf(proposal) + (counter + 1);
        }
        return proposal;
    }

    private static String findUnusedName(String prefix, Set<String> knownNames) {
        int counter = 1;
        String proposal = prefix;
        while (knownNames.contains(proposal)) {
            proposal = String.valueOf(prefix) + counter;
            ++counter;
        }
        return proposal;
    }

    public static class Class
    extends TemplateVariableResolver {
        public static final String NAME = "class";

        public Class() {
            super(NAME, Messages.PhpTemplateVariables_26);
        }

        protected String[] resolveAll(TemplateContext context) {
            ISourceModule module = ((ScriptTemplateContext)context).getSourceModule();
            int offset = ((ScriptTemplateContext)context).getCompletionOffset();
            CodeCompletionRequestor requestor = new CodeCompletionRequestor(){

                public void accept(CompletionProposal proposal) {
                    if (this.isIgnored(proposal.getKind())) {
                        return;
                    }
                    switch (proposal.getKind()) {
                        case 7: {
                            try {
                                if (PHPFlags.isNamespace((int)((IType)proposal.getModelElement()).getFlags())) break;
                                this.addProposal(proposal);
                            }
                            catch (ModelException modelException) {}
                            break;
                        }
                    }
                }

                public ICompletionContext[] createContexts() {
                    return new ICompletionContext[]{new GlobalStatementContext()};
                }
            };
            try {
                module.codeComplete(offset, (CompletionRequestor)requestor, 1000L);
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
            return requestor.getVariables();
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    public static class ClassContainer
    extends TemplateVariableResolver {
        public static final String NAME = "class_container";

        public ClassContainer() {
            super(NAME, Messages.PhpTemplateVariables_25);
        }

        protected String resolve(TemplateContext context) {
            ISourceModule module = PhpTemplateVariables.getSourceModule(context);
            if (module == null) {
                return null;
            }
            int position = ((ScriptTemplateContext)context).getCompletionOffset();
            try {
                IModelElement element = module.getElementAt(position);
                while (element != null && element.getElementType() != 7) {
                    element = element.getParent();
                }
                return element == null ? null : element.getElementName();
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
                return null;
            }
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    public static class Encoding
    extends TemplateVariableResolver {
        public static final String NAME = "encoding";

        public Encoding() {
            super(NAME, Messages.PhpTemplateVariables_23);
        }

        protected String resolve(TemplateContext context) {
            ISourceModule module;
            block3: {
                String path = null;
                try {
                    module = PhpTemplateVariables.getSourceModule(context);
                    if (module != null) break block3;
                    return null;
                }
                catch (CoreException e) {
                    PHPUiPlugin.log(e);
                    return path;
                }
            }
            IFile file = (IFile)module.getResource();
            return file.getCharset();
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    public static class FunctionContainer
    extends TemplateVariableResolver {
        public static final String NAME = "function_container";

        public FunctionContainer() {
            super(NAME, Messages.PhpTemplateVariables_24);
        }

        protected String resolve(TemplateContext context) {
            ISourceModule module = PhpTemplateVariables.getSourceModule(context);
            if (module == null) {
                return null;
            }
            int position = ((ScriptTemplateContext)context).getCompletionOffset();
            try {
                IModelElement element = module.getElementAt(position);
                while (element != null && element.getElementType() != 9) {
                    element = element.getParent();
                }
                return element == null ? null : element.getElementName();
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
                return null;
            }
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    public static class Index
    extends TemplateVariableResolver {
        public static final String NAME = "index";

        public Index() {
            super(NAME, Messages.PhpTemplateVariables_4);
        }

        protected String resolve(TemplateContext context) {
            ISourceModule module = ((ScriptTemplateContext)context).getSourceModule();
            int offset = ((ScriptTemplateContext)context).getCompletionOffset();
            VariableCodeCompletionRequestor requestor = new VariableCodeCompletionRequestor();
            try {
                module.codeComplete(offset, (CompletionRequestor)requestor, 1000L);
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
            String[] knownVars = requestor.getVariables();
            HashSet<String> knownVarsSet = new HashSet<String>(Arrays.asList(knownVars));
            return PhpTemplateVariables.findUnusedName(knownVarsSet);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    @Deprecated
    public static class Namespace
    extends TemplateVariableResolver {
        public static final String NAME = "namespace";

        public Namespace() {
            super(NAME, Messages.PhpTemplateVariables_31);
        }

        protected String resolve(TemplateContext context) {
            String path = null;
            ISourceModule module = PhpTemplateVariables.getSourceModule(context);
            if (module == null) {
                return null;
            }
            IModelElement parent = module.getParent();
            path = parent.getElementName();
            while (!(parent instanceof IProjectFragment)) {
                if ((parent = parent.getParent()).getElementName().length() == 0) break;
                path = String.valueOf(parent.getElementName()) + "\\" + path;
            }
            return path;
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    public static class NewVariable
    extends TemplateVariableResolver {
        public static final String NAME = "new_variable";

        public NewVariable() {
            super(NAME, Messages.PhpTemplateVariables_17);
        }

        protected String resolve(TemplateContext context) {
            return "dupcia";
        }

        public void resolve(TemplateVariable variable, TemplateContext context) {
            ISourceModule module = ((ScriptTemplateContext)context).getSourceModule();
            int offset = ((ScriptTemplateContext)context).getCompletionOffset();
            VariableCodeCompletionRequestor requestor = new VariableCodeCompletionRequestor();
            try {
                module.codeComplete(offset, (CompletionRequestor)requestor, 1000L);
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
            String[] knownVars = requestor.getVariables();
            HashSet<String> knownVarsSet = new HashSet<String>(Arrays.asList(knownVars));
            List params = variable.getVariableType().getParams();
            if (params.size() == 0) {
                String result = PhpTemplateVariables.findUnusedName(knownVarsSet);
                variable.setValue(result);
                variable.setResolved(true);
            } else {
                String prefix = (String)params.get(0);
                String result = PhpTemplateVariables.findUnusedName(prefix, knownVarsSet);
                variable.setValue(result);
                variable.setResolved(true);
            }
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    public static class NumberVariable
    extends TemplateVariableResolver {
        public static final String NAME = "number_variable";

        public NumberVariable() {
            super(NAME, Messages.PhpTemplateVariables_27);
        }

        protected String resolve(TemplateContext context) {
            return "dupcia";
        }

        public void resolve(TemplateVariable variable, TemplateContext context) {
            ISourceModule module = ((ScriptTemplateContext)context).getSourceModule();
            int offset = ((ScriptTemplateContext)context).getCompletionOffset();
            VariableCodeCompletionRequestor requestor = new VariableCodeCompletionRequestor();
            try {
                module.codeComplete(offset, (CompletionRequestor)requestor, 1000L);
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
            String[] knownVars = requestor.getVariables();
            HashSet<String> knownVarsSet = new HashSet<String>(Arrays.asList(knownVars));
            String result = "$" + PhpTemplateVariables.findUnusedName("index", knownVarsSet);
            variable.setValue(result);
            variable.setResolved(true);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    public static class Variable
    extends TemplateVariableResolver {
        public static final String NAME = "variable";

        public Variable() {
            super(NAME, Messages.PhpTemplateVariables_22);
        }

        protected String[] resolveAll(TemplateContext context) {
            ISourceModule module = ((ScriptTemplateContext)context).getSourceModule();
            int offset = ((ScriptTemplateContext)context).getCompletionOffset();
            VariableCodeCompletionRequestor requestor = new VariableCodeCompletionRequestor();
            try {
                module.codeComplete(offset, (CompletionRequestor)requestor, 1000L);
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
            return requestor.getVariables();
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    public static class VariableCodeCompletionRequestor
    extends CodeCompletionRequestor
    implements CompletionRequestorExtension {
        public void accept(CompletionProposal proposal) {
            if (this.isIgnored(proposal.getKind())) {
                return;
            }
            switch (proposal.getKind()) {
                case 4: {
                    this.addProposal(proposal);
                    break;
                }
                case 1: {
                    this.addProposal(proposal);
                    break;
                }
            }
        }

        public ICompletionContext[] createContexts() {
            return new ICompletionContext[]{new ClassObjMemberContext(), new GlobalMethodStatementContextForTemplate(), new GlobalStatementContextForTemplate()};
        }
    }
}

