/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.actions;

import java.io.IOException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.editor.ModelTextSelection;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;
import org.eclipse.php.internal.core.search.MethodExitsFinder;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.search.FindOccurrencesEngine;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class FindMethodExitOccurrencesAction
extends SelectionDispatchAction {
    private PHPStructuredEditor fEditor;

    public FindMethodExitOccurrencesAction(PHPStructuredEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(FindMethodExitOccurrencesAction.getEditorInput(editor) != null);
    }

    public FindMethodExitOccurrencesAction(IWorkbenchSite site) {
        super(site);
        this.setText("ActionMessages.FindMethodExitOccurrencesAction_label");
        this.setToolTipText("ActionMessages.FindMethodExitOccurrencesAction_tooltip");
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(ModelTextSelection selection) {
        try {
            IModelElement resolveEnclosingElement = selection.resolveEnclosingElement();
            Program astRoot = SharedASTProvider.getAST((ISourceModule)resolveEnclosingElement, SharedASTProvider.WAIT_YES, null);
            this.setEnabled(astRoot != null && new MethodExitsFinder().initialize(astRoot, selection.getOffset(), selection.getLength()) == null);
        }
        catch (ModelException e) {
            PHPUiPlugin.log(e);
        }
        catch (IOException e) {
            PHPUiPlugin.log(e);
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(false);
    }

    public final void run(ITextSelection ts) {
        ISourceModule input = FindMethodExitOccurrencesAction.getEditorInput(this.fEditor);
        if (!ActionUtil.isProcessable((Shell)this.getShell(), (Object)input)) {
            return;
        }
        FindOccurrencesEngine engine = FindOccurrencesEngine.create((IOccurrencesFinder)new MethodExitsFinder());
        try {
            String result = engine.run(input, ts.getOffset(), ts.getLength());
            if (result != null) {
                FindMethodExitOccurrencesAction.showMessage(this.getShell(), this.fEditor, result);
            }
        }
        catch (ModelException e) {
            PHPUiPlugin.log(e);
        }
        catch (IOException e) {
            PHPUiPlugin.log(e);
        }
    }

    private static ISourceModule getEditorInput(PHPStructuredEditor editor) {
        return PHPUiPlugin.getEditorInputTypeRoot(editor.getEditorInput());
    }

    private static void showMessage(Shell shell, PHPStructuredEditor editor, String msg) {
        IEditorStatusLine statusLine = (IEditorStatusLine)editor.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(true, msg, null);
        }
        shell.getDisplay().beep();
    }
}

