/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.test;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.RepositoryPackage;
import org.eclipse.php.composer.api.VersionedPackage;
import org.eclipse.php.composer.api.collection.Dependencies;
import org.eclipse.php.composer.api.collection.JsonArray;
import org.eclipse.php.composer.api.collection.Psr;
import org.eclipse.php.composer.api.collection.Repositories;
import org.eclipse.php.composer.api.objects.Autoload;
import org.eclipse.php.composer.api.objects.Config;
import org.eclipse.php.composer.api.objects.Distribution;
import org.eclipse.php.composer.api.objects.Extra;
import org.eclipse.php.composer.api.objects.JsonObject;
import org.eclipse.php.composer.api.objects.Namespace;
import org.eclipse.php.composer.api.objects.Person;
import org.eclipse.php.composer.api.objects.Scripts;
import org.eclipse.php.composer.api.objects.Source;
import org.eclipse.php.composer.api.objects.Support;
import org.eclipse.php.composer.api.repositories.ComposerRepository;
import org.eclipse.php.composer.api.repositories.PackageRepository;
import org.eclipse.php.composer.api.repositories.PearRepository;
import org.eclipse.php.composer.api.repositories.SubversionRepository;
import org.eclipse.php.composer.api.repositories.VcsRepository;

public abstract class ComposertTestCase
extends TestCase {
    protected static String NAME = "gossi/test";
    protected static String DESCRIPTION = "really dump description";
    protected static String[] KEYWORDS = new String[]{"stub", "oop"};
    protected static String LICENSE = "MIT";
    protected static String LICENSE_EPL = "EPL";
    protected static String TYPE = "library";
    protected static String HOMEPAGE = "http://pdt-extensions.org";
    protected static String MINIMUM_STABILITY = "dev";
    protected static String TARGET_DIR = "test/";
    protected static String PERSON1 = "Robert Gruendler";
    protected static String PERSON1_EMAIL = "r.gruendler@gmail.com";
    protected static String PERSON1_ROLE = "owner";
    protected static String PERSON2 = "Thomas Gossmann";
    protected static String PERSON2_HOMEPAGE = "http://gos.si";
    protected static String PERSON2_ROLE = "contributor";
    protected static String NAMESPACE = "gossi";
    protected static String NAMESPACE2 = "Monolog";
    protected static String NAMESPACE3 = "UniqueGlobalClass";
    protected static String NAMESPACE_PATH1 = "src/gossi";
    protected static String NAMESPACE_PATH2 = "lib/";
    protected static String NAMESPACE_PATH3 = "etc/";
    protected static String[] AUTOLOAD_MAP = new String[]{NAMESPACE_PATH1, NAMESPACE_PATH2, "Something.php"};
    protected static String[] AUTOLOAD_FILES = new String[]{"src/MyLibrary/functions.php"};
    protected static String PHP = "php";
    protected static String PHP_VERSION = ">=5.3.2";
    protected static String PHPUNIT = "phpunit/phpunit";
    protected static String PHPUNIT_VERSION = "3.7.9";
    protected static String BIN_DIR = "bin/";
    protected static boolean NOTIFY_ON_INSTALL = true;
    protected static int PROCESS_TIMEOUT = 300;
    protected static String VENDOR_DIR = "vendor/";
    protected static String[] GITHUB_PROTOCOLS = new String[]{"git", "http"};
    protected static String EMAIL = "test@mail.com";
    protected static String IRC = "irc://freenode.org/pdt";
    protected static String SOURCE = "https://github.com/pulse00/Composer-Java-Bindings";
    protected static String ISSUES = "https://github.com/pulse00/Composer-Java-Bindings/issues";
    protected static String FORUM = "https://groups.google.com/forum/?fromgroups=#!forum/pdt-extensions-platform";
    protected static String WIKI = "https://github.com/pdt-eg/Core-Plugin/wiki";
    protected static String COMPOSER_URL = "https://packagist.org/packages.json";
    protected static String PEAR_URL = "http://pear2.php.net";
    protected static String PEAR_ALIAS = "foobar";
    protected static String SVN_URL = "https://svn.github.com";
    protected static String TRUNK = "trunk/";
    protected static String BRANCHES = "branches/";
    protected static String TAGS = "tags/";
    protected static String VCS_URL = "https://github.com/Seldaek/monolog";
    protected static String SMARTY = "smarty/smarty";
    protected static String SMARTY_VERSION = "3.1.7";
    protected static String SMARTY_ZIP = "http://www.smarty.net/files/Smarty-3.1.7.zip";
    protected static String SMARTY_DIST = "zip";
    protected static String SMARTY_SVN = "http://smarty-php.googlecode.com/svn/";
    protected static String SMARTY_SOURCE = "svn";
    protected static String SMARTY_REFERENCE = "tags/Smarty_3_1_7/distribution/";
    protected static String PRE_INSTALL_CMD = "pre\\install::cmd()";
    protected static String POST_INSTALL_CMD = "post\\install::cmd()";
    protected static String POST_INSTALL_TEST = "phpunit";
    protected static String PRE_UPDATE_CMD = "pre\\update::cmd()";
    protected static String POST_UPDATE_CMD = "post\\update::cmd()";
    protected static String PRE_PACKAGE_INSTALL = "pre\\package::install()";
    protected static String POST_PACKAGE_INSTALL = "post\\package::install()";
    protected static String PRE_PACKAGE_UPDATE = "pre\\package::update()";
    protected static String POST_PACKAGE_UPDATE = "post\\package::update()";
    protected static String PRE_PACKAGE_UNINSTALL = "pre\\package::uninstall()";
    protected static String POST_PACKAGE_UNINSTALL = "post\\package::uninstall()";

    protected Reader loadFile(String name) throws URISyntaxException {
        return new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/Resources/" + name));
    }

    protected ComposerPackage createDummyPackage() {
        ComposerPackage phpPackage = new ComposerPackage();
        phpPackage.setName(NAME);
        phpPackage.setDescription(DESCRIPTION);
        phpPackage.setType(TYPE);
        phpPackage.setHomepage(HOMEPAGE);
        phpPackage.setTargetDir(TARGET_DIR);
        phpPackage.setMinimumStability(MINIMUM_STABILITY);
        JsonArray keywords = phpPackage.getKeywords();
        String[] stringArray = KEYWORDS;
        int n = KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            keywords.add((Object)keyword);
            ++n2;
        }
        Person robert = new Person();
        robert.setName(PERSON1);
        robert.setEmail(PERSON1_EMAIL);
        robert.setRole(PERSON1_ROLE);
        phpPackage.getAuthors().add((Object)robert);
        Person gossi = new Person();
        gossi.setName(PERSON2);
        gossi.setHomepage(PERSON2_HOMEPAGE);
        gossi.setRole(PERSON2_ROLE);
        phpPackage.getAuthors().add((Object)gossi);
        phpPackage.getLicense().add(LICENSE);
        phpPackage.getLicense().add(LICENSE_EPL);
        this.createAutoload(phpPackage);
        this.createDependencies(phpPackage);
        this.createRepositories(phpPackage);
        this.createSupport(phpPackage);
        this.createConfig(phpPackage);
        this.createScripts(phpPackage);
        Extra extra = phpPackage.getExtra();
        extra.set("just", (Object)"something");
        return phpPackage;
    }

    private void createAutoload(ComposerPackage phpPackage) {
        Autoload autoload = phpPackage.getAutoload();
        Namespace gossi = new Namespace();
        gossi.setNamespace(NAMESPACE);
        gossi.add(NAMESPACE_PATH1);
        autoload.getPsr0().add(gossi);
        Namespace monolog = new Namespace();
        monolog.setNamespace(NAMESPACE2);
        monolog.add(NAMESPACE_PATH1);
        monolog.add(NAMESPACE_PATH2);
        autoload.getPsr0().add(monolog);
        Namespace uniqueClass = new Namespace();
        uniqueClass.setNamespace(NAMESPACE3);
        autoload.getPsr0().add(uniqueClass);
        Namespace empty = new Namespace();
        empty.setNamespace("");
        empty.add(NAMESPACE_PATH3);
        autoload.getPsr0().add(empty);
        JsonArray map = autoload.getClassMap();
        String[] stringArray = AUTOLOAD_MAP;
        int n = AUTOLOAD_MAP.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            map.add((Object)m);
            ++n2;
        }
        JsonArray files = autoload.getFiles();
        String[] stringArray2 = AUTOLOAD_FILES;
        int n3 = AUTOLOAD_FILES.length;
        n = 0;
        while (n < n3) {
            String f = stringArray2[n];
            files.add((Object)f);
            ++n;
        }
    }

    private void createDependencies(ComposerPackage phpPackage) {
        Dependencies require = phpPackage.getRequire();
        VersionedPackage php = new VersionedPackage();
        php.setName(PHP);
        php.setVersion(PHP_VERSION);
        require.add(php);
        Dependencies requireDev = phpPackage.getRequireDev();
        VersionedPackage phpUnit = new VersionedPackage();
        phpUnit.setName(PHPUNIT);
        phpUnit.setVersion(PHPUNIT_VERSION);
        requireDev.add(phpUnit);
    }

    private void createSupport(ComposerPackage phpPackage) {
        Support support = phpPackage.getSupport();
        support.setEmail(EMAIL);
        support.setIssues(ISSUES);
        support.setSource(SOURCE);
        support.setWiki(WIKI);
        support.setForum(FORUM);
        support.setIrc(IRC);
    }

    private void createConfig(ComposerPackage phpPackage) {
        Config config = phpPackage.getConfig();
        config.setBinDir(BIN_DIR);
        config.setNotifyOnInstall(NOTIFY_ON_INSTALL);
        config.setProcessTimeout(PROCESS_TIMEOUT);
        config.setVendorDir(VENDOR_DIR);
        JsonArray githubProtocols = new JsonArray();
        String[] stringArray = GITHUB_PROTOCOLS;
        int n = GITHUB_PROTOCOLS.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            githubProtocols.add((Object)p);
            ++n2;
        }
        config.setGithubProtocols(githubProtocols);
    }

    private void createScripts(ComposerPackage phpPackage) {
        Scripts scripts = phpPackage.getScripts();
        scripts.getPreInstallCmd().add((Object)PRE_INSTALL_CMD);
        scripts.getPostInstallCmd().add((Object)POST_INSTALL_CMD);
        scripts.getPostInstallCmd().add((Object)POST_INSTALL_TEST);
        scripts.getPreUpdateCmd().add((Object)PRE_UPDATE_CMD);
        scripts.getPostUpdateCmd().add((Object)POST_UPDATE_CMD);
        scripts.getPrePackageInstall().add((Object)PRE_PACKAGE_INSTALL);
        scripts.getPostPackageInstall().add((Object)POST_PACKAGE_INSTALL);
        scripts.getPrePackageUpdate().add((Object)PRE_PACKAGE_UPDATE);
        scripts.getPostPackageUpdate().add((Object)POST_PACKAGE_UPDATE);
        scripts.getPrePackageUninstall().add((Object)PRE_PACKAGE_UNINSTALL);
        scripts.getPostPackageUninstall().add((Object)POST_PACKAGE_UNINSTALL);
    }

    private void createRepositories(ComposerPackage phpPackage) {
        Repositories repos = phpPackage.getRepositories();
        ComposerRepository composerRepo = new ComposerRepository();
        composerRepo.setUrl(COMPOSER_URL);
        repos.add((Object)composerRepo);
        JsonObject options = composerRepo.getOptions();
        JsonObject ssl = new JsonObject();
        ssl.set("verify_peer", (Object)true);
        options.set("ssl", (Object)ssl);
        SubversionRepository svnRepo = new SubversionRepository();
        svnRepo.setUrl(SVN_URL);
        svnRepo.setTrunkPath(TRUNK);
        svnRepo.setTagsPath(TAGS);
        svnRepo.setBranchesPath(BRANCHES);
        repos.add((Object)svnRepo);
        PearRepository pearRepo = new PearRepository();
        pearRepo.setUrl(PEAR_URL);
        pearRepo.setVendorAlias(PEAR_ALIAS);
        repos.add((Object)pearRepo);
        PackageRepository pkgRepo = new PackageRepository();
        repos.add((Object)pkgRepo);
        RepositoryPackage pkg = pkgRepo.getPackage();
        pkg.setName(SMARTY);
        pkg.setVersion(SMARTY_VERSION);
        Distribution dist = pkg.getDist();
        dist.setType(SMARTY_DIST);
        dist.setUrl(SMARTY_ZIP);
        Source src = pkg.getSource();
        src.setType(SMARTY_SOURCE);
        src.setUrl(SMARTY_SVN);
        src.setReference(SMARTY_REFERENCE);
        VcsRepository vcsRepo = new VcsRepository();
        vcsRepo.setUrl(VCS_URL);
        repos.add((Object)vcsRepo);
    }

    protected void doTestComposerPackage(ComposerPackage phpPackage) {
        ComposertTestCase.assertNotNull((Object)phpPackage);
        ComposertTestCase.assertEquals((String)NAME, (String)phpPackage.getName());
        ComposertTestCase.assertEquals((String)TYPE, (String)phpPackage.getType());
        ComposertTestCase.assertEquals((String)DESCRIPTION, (String)phpPackage.getDescription());
        ComposertTestCase.assertEquals((Object)KEYWORDS[0], (Object)phpPackage.getKeywords().get(0));
        ComposertTestCase.assertEquals((String)HOMEPAGE, (String)phpPackage.getHomepage());
        ComposertTestCase.assertEquals((String)TARGET_DIR, (String)phpPackage.getTargetDir());
        ComposertTestCase.assertEquals((String)MINIMUM_STABILITY, (String)phpPackage.getMinimumStability());
        ComposertTestCase.assertNotNull((String)"Authors not NULL", (Object)phpPackage.getAuthors());
        ComposertTestCase.assertEquals((int)2, (int)phpPackage.getAuthors().size());
        Person robert = (Person)phpPackage.getAuthors().get(0);
        ComposertTestCase.assertEquals((String)PERSON1, (String)robert.getName());
        ComposertTestCase.assertEquals((String)PERSON1_EMAIL, (String)robert.getEmail());
        ComposertTestCase.assertEquals((String)PERSON1_ROLE, (String)robert.getRole());
        Person gossi = (Person)phpPackage.getAuthors().get(1);
        ComposertTestCase.assertEquals((String)PERSON2, (String)gossi.getName());
        ComposertTestCase.assertEquals((String)PERSON2_HOMEPAGE, (String)gossi.getHomepage());
        ComposertTestCase.assertEquals((String)PERSON2_ROLE, (String)gossi.getRole());
        ComposertTestCase.assertEquals((int)2, (int)phpPackage.getLicense().size());
        ComposertTestCase.assertEquals((String)LICENSE, (String)((String)phpPackage.getLicense().get(0)));
        ComposertTestCase.assertEquals((String)LICENSE_EPL, (String)((String)phpPackage.getLicense().get(1)));
        ComposertTestCase.assertEquals((int)KEYWORDS.length, (int)phpPackage.getKeywords().size());
    }

    protected void doTestDependencies(ComposerPackage phpPackage) {
        ComposertTestCase.assertNotNull((Object)phpPackage.getRequire());
        ComposertTestCase.assertEquals((int)1, (int)phpPackage.getRequire().size());
        Dependencies require = phpPackage.getRequire();
        for (VersionedPackage dep : require) {
            ComposertTestCase.assertNotNull((Object)dep.getName());
            ComposertTestCase.assertNotNull((Object)dep.getVersion());
        }
        ComposertTestCase.assertNotNull((Object)phpPackage.getRequireDev());
    }

    protected void doTestAutoload(ComposerPackage phpPackage) {
        Autoload al = phpPackage.getAutoload();
        ComposertTestCase.assertNotNull((Object)al);
        Psr psr = al.getPsr0();
        ComposertTestCase.assertEquals((int)4, (int)psr.size());
        ComposertTestCase.assertEquals((int)1, (int)((Namespace)psr.get(NAMESPACE)).size());
        ComposertTestCase.assertEquals((String)NAMESPACE_PATH1, (String)((Namespace)psr.get(NAMESPACE)).getFirst());
        ComposertTestCase.assertEquals((int)2, (int)((Namespace)psr.get(NAMESPACE2)).size());
        ComposertTestCase.assertEquals((Object)NAMESPACE_PATH2, (Object)((Namespace)psr.get(NAMESPACE2)).getPaths().get(1));
        ComposertTestCase.assertEquals((int)1, (int)((Namespace)psr.get(NAMESPACE3)).size());
        ComposertTestCase.assertEquals((String)"", (String)((Namespace)psr.get(NAMESPACE3)).getFirst());
        ComposertTestCase.assertNotNull((Object)psr.get(""));
        ComposertTestCase.assertEquals((String)NAMESPACE_PATH3, (String)((Namespace)psr.get("")).getFirst());
        ComposertTestCase.assertTrue((boolean)al.hasClassMap());
        JsonArray classMap = al.getClassMap();
        ComposertTestCase.assertEquals((int)3, (int)classMap.size());
        ComposertTestCase.assertTrue((boolean)al.hasFiles());
        JsonArray files = al.getFiles();
        ComposertTestCase.assertEquals((int)1, (int)files.size());
    }

    protected void doTestSupport(ComposerPackage phpPackage) {
        Support support = phpPackage.getSupport();
        ComposertTestCase.assertEquals((String)EMAIL, (String)support.getEmail());
        ComposertTestCase.assertEquals((String)IRC, (String)support.getIrc());
        ComposertTestCase.assertEquals((String)ISSUES, (String)support.getIssues());
        ComposertTestCase.assertEquals((String)FORUM, (String)support.getForum());
        ComposertTestCase.assertEquals((String)WIKI, (String)support.getWiki());
        ComposertTestCase.assertEquals((String)SOURCE, (String)support.getSource());
    }

    protected void doTestScripts(ComposerPackage phpPackage) {
        Scripts scripts = phpPackage.getScripts();
        ComposertTestCase.assertEquals((Object)PRE_INSTALL_CMD, (Object)scripts.getPreInstallCmd().get(0));
        ComposertTestCase.assertEquals((int)2, (int)scripts.getPostInstallCmd().size());
        ComposertTestCase.assertEquals((Object)POST_INSTALL_CMD, (Object)scripts.getPostInstallCmd().get(0));
        ComposertTestCase.assertEquals((Object)POST_INSTALL_TEST, (Object)scripts.getPostInstallCmd().get(1));
        ComposertTestCase.assertEquals((Object)PRE_UPDATE_CMD, (Object)scripts.getPreUpdateCmd().get(0));
        ComposertTestCase.assertEquals((Object)POST_UPDATE_CMD, (Object)scripts.getPostUpdateCmd().get(0));
        ComposertTestCase.assertEquals((Object)PRE_PACKAGE_INSTALL, (Object)scripts.getPrePackageInstall().get(0));
        ComposertTestCase.assertEquals((Object)POST_PACKAGE_INSTALL, (Object)scripts.getPostPackageInstall().get(0));
        ComposertTestCase.assertEquals((Object)PRE_PACKAGE_UPDATE, (Object)scripts.getPrePackageUpdate().get(0));
        ComposertTestCase.assertEquals((Object)POST_PACKAGE_UPDATE, (Object)scripts.getPostPackageUpdate().get(0));
        ComposertTestCase.assertEquals((Object)PRE_PACKAGE_UNINSTALL, (Object)scripts.getPrePackageUninstall().get(0));
        ComposertTestCase.assertEquals((Object)POST_PACKAGE_UNINSTALL, (Object)scripts.getPostPackageUninstall().get(0));
    }

    protected void doTestConfig(ComposerPackage phpPackage) {
        Config config = phpPackage.getConfig();
        ComposertTestCase.assertNotNull((Object)config);
        ComposertTestCase.assertEquals((String)VENDOR_DIR, (String)config.getVendorDir());
        ComposertTestCase.assertEquals((String)BIN_DIR, (String)config.getBinDir());
        ComposertTestCase.assertEquals((int)PROCESS_TIMEOUT, (int)config.getProcessTimeout());
        ComposertTestCase.assertEquals((int)GITHUB_PROTOCOLS.length, (int)config.getGithubProtocols().size());
        ComposertTestCase.assertEquals((boolean)NOTIFY_ON_INSTALL, (boolean)config.getNotifyOnInstall());
    }

    protected void doTestRepositories(ComposerPackage phpPackage) {
        Repositories repos = phpPackage.getRepositories();
        ComposertTestCase.assertNotNull((Object)repos);
        ComposertTestCase.assertTrue((boolean)(repos.get(0) instanceof ComposerRepository));
        ComposertTestCase.assertTrue((boolean)(repos.get(1) instanceof SubversionRepository));
        ComposertTestCase.assertTrue((boolean)(repos.get(2) instanceof PearRepository));
        ComposertTestCase.assertTrue((boolean)(repos.get(3) instanceof PackageRepository));
        ComposertTestCase.assertTrue((boolean)(repos.get(4) instanceof VcsRepository));
        ComposerRepository composer = (ComposerRepository)repos.get(0);
        ComposertTestCase.assertEquals((String)COMPOSER_URL, (String)composer.getUrl());
        ComposertTestCase.assertTrue((boolean)(composer.getOptions() instanceof JsonObject));
        JsonObject options = composer.getOptions();
        ComposertTestCase.assertTrue((boolean)options.has("ssl"));
        ComposertTestCase.assertTrue((boolean)options.isObject("ssl"));
        JsonObject ssl = options.getAsObject("ssl");
        ComposertTestCase.assertTrue((boolean)ssl.has("verify_peer"));
        ComposertTestCase.assertTrue((boolean)ssl.getAsBoolean("verify_peer"));
        SubversionRepository subversion = (SubversionRepository)repos.get(1);
        ComposertTestCase.assertEquals((String)SVN_URL, (String)subversion.getUrl());
        ComposertTestCase.assertEquals((String)TRUNK, (String)subversion.getTrunkPath());
        ComposertTestCase.assertEquals((String)BRANCHES, (String)subversion.getBranchesPath());
        ComposertTestCase.assertEquals((String)TAGS, (String)subversion.getTagsPath());
        PearRepository pear = (PearRepository)repos.get(2);
        ComposertTestCase.assertEquals((String)PEAR_URL, (String)pear.getUrl());
        ComposertTestCase.assertEquals((String)PEAR_ALIAS, (String)pear.getVendorAlias());
        PackageRepository pkgRepo = (PackageRepository)repos.get(3);
        ComposertTestCase.assertNotNull((Object)pkgRepo);
        RepositoryPackage pkg = pkgRepo.getPackage();
        ComposertTestCase.assertNotNull((Object)pkg);
        ComposertTestCase.assertEquals((String)SMARTY, (String)pkg.getName());
        ComposertTestCase.assertEquals((String)SMARTY_VERSION, (String)pkg.getVersion());
        ComposertTestCase.assertNotNull((Object)pkg.getDist());
        ComposertTestCase.assertTrue((boolean)(pkg.getDist() instanceof Distribution));
        ComposertTestCase.assertEquals((String)SMARTY_ZIP, (String)pkg.getDist().getUrl());
        ComposertTestCase.assertEquals((String)SMARTY_DIST, (String)pkg.getDist().getType());
        ComposertTestCase.assertNotNull((Object)pkg.getSource());
        ComposertTestCase.assertTrue((boolean)(pkg.getSource() instanceof Source));
        ComposertTestCase.assertEquals((String)SMARTY_SVN, (String)pkg.getSource().getUrl());
        ComposertTestCase.assertEquals((String)SMARTY_SOURCE, (String)pkg.getSource().getType());
        ComposertTestCase.assertEquals((String)SMARTY_REFERENCE, (String)pkg.getSource().getReference());
    }
}

