/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.buildpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.php.composer.core.ComposerPlugin;
import org.eclipse.php.composer.core.buildpath.BuildPathParser;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.core.resources.IComposerProject;
import org.eclipse.php.internal.core.buildpath.BuildPathUtils;
import org.eclipse.wst.validation.ValidationFramework;

public class BuildPathManager {
    private IComposerProject composerProject;
    private IPath[] exclusions;
    private IPath vendorPath;
    private IPath composerPath;

    public BuildPathManager(IComposerProject composerProject) {
        this.composerProject = composerProject;
    }

    public void update() throws CoreException {
        this.update((IProgressMonitor)new NullProgressMonitor());
    }

    public void update(IProgressMonitor monitor) throws CoreException {
        IFolder folder;
        IBuildpathEntry[] rawBuildpath;
        IBuildpathEntry[] exc;
        IPath[] inclusions;
        if (!this.composerProject.isValidComposerJson()) {
            Logger.log(1, "Stop BuildPathManager, composer.json invalid");
            return;
        }
        this.vendorPath = this.composerProject.getProject().getFullPath().append(this.composerProject.getVendorDir());
        this.composerPath = this.vendorPath.append("composer");
        IProject project = this.composerProject.getProject();
        IScriptProject scriptProject = this.composerProject.getScriptProject();
        BuildPathParser parser = new BuildPathParser(this.composerProject);
        List<String> paths = parser.getPaths();
        IEclipsePreferences prefs = ComposerPlugin.getDefault().getProjectPreferences(project);
        try {
            String encoded = prefs.get("org.eclipse.php.composer.corebuildpath.includes.excludes", "");
            this.exclusions = scriptProject.decodeBuildpathEntry(encoded).getExclusionPatterns();
            inclusions = scriptProject.decodeBuildpathEntry(encoded).getInclusionPatterns();
        }
        catch (Exception exception) {
            this.exclusions = new IPath[0];
            inclusions = new IPath[]{};
        }
        IPath[] iPathArray = inclusions;
        int n = inclusions.length;
        int n2 = 0;
        while (n2 < n) {
            IPath inclusion = iPathArray[n2];
            paths.add(inclusion.toString());
            ++n2;
        }
        ArrayList<IPath> exs = new ArrayList<IPath>();
        IPath[] iPathArray2 = this.exclusions;
        int n3 = this.exclusions.length;
        n = 0;
        while (n < n3) {
            IPath exclusion = iPathArray2[n];
            exc = exclusion.removeTrailingSeparator().toString();
            if (paths.contains(exc)) {
                paths.remove(exc);
            } else {
                exs.add(exclusion);
            }
            ++n;
        }
        this.exclusions = exs.toArray(new IPath[0]);
        exc = rawBuildpath = scriptProject.getRawBuildpath();
        int n4 = rawBuildpath.length;
        n3 = 0;
        while (n3 < n4) {
            IBuildpathEntry entry = exc[n3];
            if (entry.getEntryKind() == 3) {
                BuildPathUtils.removeEntryFromBuildPath((IScriptProject)scriptProject, (IBuildpathEntry)entry);
            }
            ++n3;
        }
        Collections.sort(paths);
        ArrayList<IBuildpathEntry> newEntries = new ArrayList<IBuildpathEntry>();
        for (String path : paths) {
            Path entry = new Path(path);
            IFolder folder2 = project.getFolder((IPath)entry);
            if (folder2 == null || !folder2.exists()) continue;
            this.addPath(folder2.getFullPath(), newEntries);
        }
        if (newEntries.size() > 0) {
            BuildPathUtils.addNonDupEntriesToBuildPath((IScriptProject)scriptProject, newEntries);
        }
        if ((folder = project.getFolder((IPath)new Path(this.composerProject.getVendorDir()))) != null && folder.exists()) {
            if (!folder.isDerived()) {
                folder.setDerived(true, monitor);
            }
            ValidationFramework.getDefault().disableValidation((IResource)folder);
        }
    }

    private void addPath(IPath path, List<IBuildpathEntry> entries) {
        IBuildpathEntry parent = null;
        int parentLength = 0;
        for (IBuildpathEntry entry : entries) {
            IPath entryPath = entry.getPath();
            if (!entryPath.isPrefixOf(path) || parent != null && entryPath.toString().length() <= parentLength) continue;
            parent = entry;
            parentLength = parent.getPath().toString().length();
        }
        if (parent != null) {
            ArrayList<IPath> exclusions = new ArrayList<IPath>();
            exclusions.addAll(Arrays.asList(parent.getExclusionPatterns()));
            IPath diff = path.removeFirstSegments(path.matchingFirstSegments(parent.getPath()));
            if (parent.getPath().equals((Object)this.composerPath)) {
                diff = diff.uptoSegment(1);
            }
            if (!exclusions.contains(diff = diff.removeTrailingSeparator().addTrailingSeparator())) {
                exclusions.add(diff);
            }
            entries.remove(parent);
            parent = DLTKCore.newSourceEntry((IPath)parent.getPath(), (IPath[])exclusions.toArray(new IPath[0]));
            entries.add(parent);
        }
        if (this.vendorPath.equals((Object)path) || this.composerPath.equals((Object)path)) {
            entries.add(DLTKCore.newSourceEntry((IPath)path));
        } else {
            ArrayList<IPath> ex = new ArrayList<IPath>();
            IPath[] iPathArray = this.exclusions;
            int n = this.exclusions.length;
            int n2 = 0;
            while (n2 < n) {
                IPath exclusion = iPathArray[n2];
                if (!exclusion.toString().startsWith("*")) {
                    exclusion = this.composerProject.getProject().getFullPath().append(exclusion);
                }
                if (path.equals((Object)exclusion)) {
                    return;
                }
                if (path.removeTrailingSeparator().isPrefixOf(exclusion)) {
                    ex.add(exclusion.removeFirstSegments(path.matchingFirstSegments(exclusion)));
                } else if (exclusion.toString().startsWith("*")) {
                    ex.add(exclusion);
                }
                ++n2;
            }
            entries.add(DLTKCore.newSourceEntry((IPath)path, (IPath[])ex.toArray(new IPath[0])));
        }
    }

    public static void setExclusionPattern(IScriptProject project, IBuildpathEntry entry) {
        try {
            String encoded = project.encodeBuildpathEntry(entry);
            IEclipsePreferences prefs = ComposerPlugin.getDefault().getProjectPreferences(project.getProject());
            prefs.put("org.eclipse.php.composer.corebuildpath.includes.excludes", encoded);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }
}

