/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.facet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class UninstallActionDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion version, Object object, IProgressMonitor progress) throws CoreException {
        if (!project.hasNature("org.eclipse.php.core.PHPNature")) {
            return;
        }
        int index = this.getBuilderIndex(project);
        if (index != -1) {
            progress.subTask("Uninstalling composer builder");
            IProjectDescription description = project.getDescription();
            ArrayList<ICommand> commands = new ArrayList<ICommand>();
            commands.addAll(Arrays.asList(description.getBuildSpec()));
            commands.remove(index);
            description.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
            project.setDescription(description, null);
        }
    }

    private int getBuilderIndex(IProject project) {
        try {
            int i = 0;
            ICommand[] iCommandArray = project.getDescription().getBuildSpec();
            int n = iCommandArray.length;
            int n2 = 0;
            while (n2 < n) {
                String launch;
                Map args;
                ICommand cmd = iCommandArray[n2];
                if ("org.eclipse.php.composer.core.builder.buildPathManagementBuilder".equals(cmd.getBuilderName())) {
                    return i;
                }
                if ("org.eclipse.ui.externaltools.ExternalToolBuilder".equals(cmd.getBuilderName()) && (args = cmd.getArguments()).containsKey("LaunchConfigHandle") && (launch = (String)args.get("LaunchConfigHandle")).contains("org.eclipse.php.composer.core.builder.buildPathManagementBuilder")) {
                    return i;
                }
                ++i;
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return -1;
    }
}

