/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.launch;

import java.util.TreeMap;
import org.eclipse.php.composer.core.launch.ExecutableNotFoundException;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;

public class LaunchUtil {
    public static String getPHPExecutable() throws ExecutableNotFoundException {
        return LaunchUtil.getPHPExecutable("");
    }

    public static String getPHPExecutable(String debugger) throws ExecutableNotFoundException {
        PHPexeItem defaultPhpExe = LaunchUtil.getDefaultPHPExeItem(debugger);
        if ("CLI".equals(defaultPhpExe.getSapiType())) {
            return defaultPhpExe.getExecutable().toString();
        }
        PHPexeItem[] cliItems = PHPexes.getInstance().getCLIItems();
        if (cliItems.length == 0) {
            return defaultPhpExe.getExecutable().toString();
        }
        TreeMap<String, PHPexeItem> map = new TreeMap<String, PHPexeItem>();
        PHPexeItem[] pHPexeItemArray = cliItems;
        int n = cliItems.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem item = pHPexeItemArray[n2];
            map.put(item.getVersion(), item);
            ++n2;
        }
        PHPexeItem phpExe = (PHPexeItem)map.get(defaultPhpExe.getVersion());
        if (phpExe != null) {
            return phpExe.getExecutable().toString();
        }
        phpExe = (PHPexeItem)map.get(map.lastKey());
        return phpExe.getExecutable().toString();
    }

    private static PHPexeItem getDefaultPHPExeItem(String debugger) throws ExecutableNotFoundException {
        PHPexeItem phpExe = PHPexes.getInstance().getDefaultItem();
        if (phpExe != null) {
            return phpExe;
        }
        throw new ExecutableNotFoundException("Unable to find PHP executable");
    }
}

