/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.launch;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.ExecuteException;
import org.eclipse.core.resources.IProject;
import org.eclipse.php.composer.core.launch.ScriptNotFoundException;
import org.eclipse.php.composer.core.launch.environment.Environment;
import org.eclipse.php.composer.core.launch.execution.ExecutionResponseListener;
import org.eclipse.php.composer.core.launch.execution.ScriptExecutor;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;

public class ScriptLauncher {
    private Environment environment;
    private IProject project;
    private ScriptExecutor executor;
    private Set<ExecutionResponseListener> listeners = new HashSet<ExecutionResponseListener>();
    private Integer timeout = null;

    public ScriptLauncher(Environment environment, IProject project) throws ScriptNotFoundException {
        this.environment = environment;
        this.project = project;
        this.environment.setUp(project);
    }

    public void addResponseListener(ExecutionResponseListener listener) {
        this.listeners.add(listener);
    }

    public void removeResponseListener(ExecutionResponseListener listener) {
        this.listeners.remove(listener);
    }

    public void launch(String argument) throws ExecuteException, IOException, InterruptedException {
        this.launch(argument, new String[0]);
    }

    public void launch(String argument, String param) throws ExecuteException, IOException, InterruptedException {
        this.launch(argument, new String[]{param});
    }

    public void launch(String argument, String[] params) throws ExecuteException, IOException, InterruptedException {
        CommandLine cmd = this.environment.getCommand();
        cmd.addArgument(argument);
        cmd.addArguments(params);
        this.executor = new ScriptExecutor();
        if (this.timeout != null) {
            this.executor.setTimeout(this.timeout);
        }
        Logger.debug("Setting executor working directory to " + this.project.getLocation().toOSString());
        this.executor.setWorkingDirectory(this.project.getLocation().toFile());
        for (ExecutionResponseListener listener : this.listeners) {
            this.executor.addResponseListener(listener);
        }
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        PHPLaunchUtilities.appendLibrarySearchPathEnv(env, (File)new File(cmd.getExecutable()).getParentFile());
        this.executor.execute(cmd, env);
    }

    public void abort() {
        this.executor.abort();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

