/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.controller;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.php.composer.api.objects.Scripts;
import org.eclipse.php.composer.ui.ComposerUIPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeItem;

public class ScriptsController
extends StyledCellLabelProvider
implements ITreeContentProvider {
    private Scripts scripts;
    private Image eventImage = ComposerUIPluginImages.EVENT.createImage();
    private Image scriptImage = ComposerUIPluginImages.SCRIPT.createImage();
    private TreeViewer viewer;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
        this.scripts = (Scripts)newInput;
    }

    public String getText(Object element) {
        return element.toString();
    }

    public void update(ViewerCell cell) {
        Object obj = cell.getElement();
        String text = this.getText(obj);
        StyledString styledString = new StyledString(text);
        if (Arrays.asList(Scripts.getEvents()).contains(text)) {
            int count = this.scripts.getAsArray(text).size();
            styledString.append(" (" + count + ")", StyledString.COUNTER_STYLER);
            cell.setImage(this.eventImage);
        } else {
            cell.setImage(this.scriptImage);
        }
        cell.setText(styledString.toString());
        cell.setStyleRanges(styledString.getStyleRanges());
        super.update(cell);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Scripts) {
            Scripts scripts = (Scripts)parentElement;
            ArrayList<String> children = new ArrayList<String>();
            String[] stringArray = Scripts.getEvents();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String event = stringArray[n2];
                if (scripts.has(event)) {
                    children.add(event);
                }
                ++n2;
            }
            return children.toArray();
        }
        String text = parentElement.toString();
        if (Arrays.asList(Scripts.getEvents()).contains(text)) {
            return this.scripts.getAsArray(text).toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        TreeItem item = null;
        TreeItem[] treeItemArray = this.viewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ri = treeItemArray[n2];
            TreeItem[] treeItemArray2 = ri.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem i = treeItemArray2[n4];
                if (i.getData() == element) {
                    item = i;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (item != null) {
            TreeItem parent = item.getParentItem();
            if (parent == null) {
                return this.scripts;
            }
            if (parent.getData() != null) {
                return parent.getData();
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }
}

