/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.internal.debug.ui.preferences.phps.PHPsPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class MissingExecutableDialog
extends ErrorDialog {
    private final Shell shell;

    public MissingExecutableDialog(Shell parentShell, IStatus info) {
        super(parentShell, "Problem running composer", "Unable to run composer.", info, 14);
        this.shell = parentShell;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = (Composite)super.createDialogArea(parent);
        Composite space = new Composite(main, 0);
        GridData gridData = new GridData(4, 4, false, false);
        gridData.heightHint = 1;
        gridData.widthHint = 1;
        space.setLayoutData((Object)gridData);
        Link link = this.createPreferencesLink(main);
        link.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        return main;
    }

    private Link createPreferencesLink(Composite parent) {
        Link link = new Link(parent, 0);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)MissingExecutableDialog.this.shell, (String)PHPsPreferencePage.ID, (String[])new String[0], null);
                    preferenceDialog.open();
                    MissingExecutableDialog.this.close();
                }
                catch (Exception e2) {
                    Logger.logException((Throwable)e2);
                }
            }
        });
        link.setText("You need to <a>configure a PHP executable</a> in your preferences in order \nfor the Composer plugin to be able to run composer.");
        link.setToolTipText("Open the PHP preference page to configure the available PHP executables");
        Dialog.applyDialogFont((Control)link);
        return link;
    }
}

