/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.editor.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.VersionedPackage;
import org.eclipse.php.composer.api.collection.ComposerPackages;
import org.eclipse.php.composer.api.json.ParseException;
import org.eclipse.php.composer.core.buildpath.BuildPathManager;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.core.resources.IComposerProject;
import org.eclipse.php.composer.internal.core.resources.ComposerProject;
import org.eclipse.php.composer.ui.actions.InstallAction;
import org.eclipse.php.composer.ui.actions.InstallDevAction;
import org.eclipse.php.composer.ui.actions.SelfUpdateAction;
import org.eclipse.php.composer.ui.actions.UpdateAction;
import org.eclipse.php.composer.ui.actions.UpdateDevAction;
import org.eclipse.php.composer.ui.editor.ComposerFormPage;
import org.eclipse.php.composer.ui.editor.composer.AutoloadPage;
import org.eclipse.php.composer.ui.editor.composer.ConfigurationPage;
import org.eclipse.php.composer.ui.editor.composer.DependenciesPage;
import org.eclipse.php.composer.ui.editor.composer.DependencyGraphPage;
import org.eclipse.php.composer.ui.editor.composer.OverviewPage;
import org.eclipse.php.composer.ui.job.ComposerJob;
import org.eclipse.php.composer.ui.job.UpdateDevJob;
import org.eclipse.php.composer.ui.job.UpdateJob;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class ComposerFormEditor
extends SharedHeaderFormEditor {
    public static final String ID = "org.eclipse.php.composer.ui.editor.composer.ComposerEditor";
    public static final String MSG_PARSE_ERROR = "org.eclipse.php.composer.ui.editor.composer.ParseException";
    protected boolean dirty = false;
    protected ComposerPackage composerPackage = null;
    protected IDocumentProvider documentProvider;
    private ISharedImages sharedImages = null;
    private IProject project;
    private IComposerProject composerProject;
    private BuildPathManager buildPathManager;
    private IAction installAction = null;
    private IAction installDevAction = null;
    private IAction updateAction = null;
    private IAction updateNoDevAction = null;
    private IAction selfUpdateAction = null;
    private int jsonEditorIndex;
    private int lastPageIndex = -1;
    protected OverviewPage overviewPage;
    protected DependenciesPage dependenciesPage;
    protected ConfigurationPage configurationPage;
    protected AutoloadPage autoloadPage;
    protected StructuredTextEditor jsonEditor = new StructuredTextEditor();
    protected DependencyGraphPage graphPage;
    protected IToolBarManager toolbarManager;
    private IFile jsonFile;
    private String jsonDump = null;
    private boolean saving = false;
    private boolean pageChanging = false;
    private boolean validJson = true;
    private boolean newDepSinceLastSave = false;
    private boolean newDevDepSinceLastSave = false;

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.documentProvider = this.jsonEditor.getDocumentProvider();
        this.documentProvider.getDocument((Object)this.getEditorInput()).addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                ComposerFormEditor.this.documentChanged(event);
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
                ComposerFormEditor.this.documentAboutToBeChanged(event);
            }
        });
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.jsonEditor.init(site, input);
        super.init(site, input);
        if (input instanceof IFileEditorInput) {
            this.jsonFile = ((IFileEditorInput)input).getFile();
            if (this.jsonFile != null) {
                this.project = this.jsonFile.getProject();
                this.composerProject = new ComposerProject(this.project);
                this.buildPathManager = new BuildPathManager(this.composerProject);
                this.setPartName(this.project.getName());
                ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

                    public void resourceChanged(IResourceChangeEvent event) {
                        ComposerFormEditor.this.resourceChanged(event);
                    }
                });
            }
        }
        this.composerPackage = new ComposerPackage();
        this.composerPackage.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Logger.debug((String)("Property change: " + e.getPropertyName() + ", oldValue: " + e.getOldValue() + ", newValue: " + e.getNewValue()));
                if (e.getPropertyName().startsWith("require")) {
                    ComposerFormEditor.this.newDepSinceLastSave = true;
                }
                if (e.getPropertyName().startsWith("require-dev")) {
                    ComposerFormEditor.this.newDevDepSinceLastSave = true;
                }
                ComposerFormEditor.this.setDirty(true);
            }
        });
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        super.createHeaderContents(headerForm);
        ScrolledForm header = headerForm.getForm();
        header.setText("Composer");
        FormToolkit toolkit = headerForm.getToolkit();
        toolkit.decorateFormHeading(header.getForm());
        this.toolbarManager = (ToolBarManager)header.getToolBarManager();
    }

    protected void createPages() {
        this.overviewPage = new OverviewPage(this, "org.eclipse.php.composer.ui.editor.composer.OverviewPage", "Overview");
        this.dependenciesPage = new DependenciesPage(this, "org.eclipse.php.composer.ui.editor.composer.DependencyPage", "Dependencies");
        this.configurationPage = new ConfigurationPage(this, "org.eclipse.php.composer.ui.editor.composer.ConfigurationPage", "Configuration");
        this.autoloadPage = new AutoloadPage(this, "org.eclipse.php.composer.ui.editor.composer.AutoloadPage", "Autoload");
        this.graphPage = new DependencyGraphPage(this, "org.eclipse.php.composer.ui.editor.composer.DependencyGraphPage", "Dependency Graph");
        super.createPages();
        for (Object pageObj : this.pages) {
            if (!(pageObj instanceof ComposerFormPage) || pageObj == this.jsonEditor) continue;
            ComposerFormPage page = (ComposerFormPage)((Object)pageObj);
            page.contributeToToolbar(this.toolbarManager, this.getHeaderForm());
        }
        this.contributeToToolbar(this.toolbarManager);
        this.jsonDump = this.documentProvider.getDocument((Object)this.getEditorInput()).get();
        this.parse(this.jsonDump);
        this.setDirty(false);
        this.newDepSinceLastSave = false;
        this.newDevDepSinceLastSave = false;
        if (!this.validJson) {
            this.setActivePage(this.jsonEditorIndex);
            IManagedForm headerForm = this.getHeaderForm();
            if (headerForm != null) {
                headerForm.getMessageManager().update();
            }
        }
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)this.overviewPage);
            this.addPage((IFormPage)this.dependenciesPage);
            this.addPage((IFormPage)this.autoloadPage);
            this.addPage((IFormPage)this.configurationPage);
            this.addPage((IFormPage)this.graphPage);
            this.jsonEditorIndex = this.addPage((IEditorPart)this.jsonEditor, this.getEditorInput());
            this.setPageText(this.jsonEditorIndex, this.jsonEditor.getTitle());
        }
        catch (PartInitException e) {
            Logger.logException((Throwable)e);
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.pageChanging = true;
        if (this.isJsonEditor()) {
            if (this.validJson) {
                IDocument document = this.documentProvider.getDocument((Object)this.getEditorInput());
                String json = this.composerPackage.toJson();
                document.set(json);
                this.setDirty(this.jsonDump != null && !this.jsonDump.equals(json));
                this.jsonDump = json;
            }
            this.getHeaderForm().getForm().setText(this.jsonEditor.getTitle());
        }
        if (this.lastPageIndex != -1 && this.lastPageIndex == this.jsonEditorIndex) {
            String json = this.documentProvider.getDocument((Object)this.jsonEditor.getEditorInput()).get();
            if (this.jsonDump != null && !this.jsonDump.equals(json)) {
                boolean dirty = this.isDirty();
                this.parse(json);
                this.setDirty(dirty);
            }
        }
        this.lastPageIndex = newPageIndex;
        this.pageChanging = false;
    }

    protected void contributeToToolbar(IToolBarManager manager) {
        manager.add(this.getInstallAction());
        manager.add(this.getInstallDevAction());
        manager.add((IContributionItem)new Separator());
        manager.add(this.getUpdateNoDevAction());
        manager.add(this.getUpdateAction());
        manager.add((IContributionItem)new Separator());
        manager.add(this.getSelfUpdateAction());
        manager.update(true);
    }

    public void dispose() {
        this.toolbarManager = null;
        super.dispose();
    }

    protected ISharedImages getSharedImages() {
        if (this.sharedImages == null) {
            this.sharedImages = this.getSite().getPage().getWorkbenchWindow().getWorkbench().getSharedImages();
        }
        return this.sharedImages;
    }

    protected IAction getInstallAction() {
        if (this.installAction == null) {
            this.installAction = new InstallAction(this.project, this.getSite());
        }
        return this.installAction;
    }

    protected IAction getInstallDevAction() {
        if (this.installDevAction == null) {
            this.installDevAction = new InstallDevAction(this.project, this.getSite());
        }
        return this.installDevAction;
    }

    protected IAction getUpdateAction() {
        if (this.updateAction == null) {
            this.updateAction = new UpdateDevAction(this.project, this.getSite());
        }
        return this.updateAction;
    }

    protected IAction getUpdateNoDevAction() {
        if (this.updateNoDevAction == null) {
            this.updateNoDevAction = new UpdateAction(this.project, this.getSite());
        }
        return this.updateNoDevAction;
    }

    protected IAction getSelfUpdateAction() {
        if (this.selfUpdateAction == null) {
            this.selfUpdateAction = new SelfUpdateAction(this.project, this.getSite());
        }
        return this.selfUpdateAction;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.saving = true;
            IDocument document = this.documentProvider.getDocument((Object)this.getEditorInput());
            if (this.isJsonEditor()) {
                this.parse(document.get());
            } else {
                this.validateJson(document.get());
            }
            if (!this.isJsonEditor() && this.isValidJson()) {
                document.set(this.composerPackage.toJson());
            }
            this.documentProvider.aboutToChange((Object)this.getEditorInput());
            this.documentProvider.saveDocument(monitor, (Object)this.getEditorInput(), document, true);
            this.documentProvider.changed((Object)this.getEditorInput());
            this.jsonDump = document.get();
            this.setDirty(false);
            this.saving = false;
            PreferencesSupport prefSupport = new PreferencesSupport("org.eclipse.php.composer.core");
            Boolean buildpath = prefSupport.getProjectSpecificBooleanPreferencesValue("org.eclipse.php.composer.coresaveaction.buildpath", false, this.project);
            Boolean update = prefSupport.getProjectSpecificBooleanPreferencesValue("org.eclipse.php.composer.coresaveaction.update", false, this.project);
            update = update != false && (this.newDepSinceLastSave || this.newDevDepSinceLastSave);
            if (update.booleanValue()) {
                ComposerJob job = this.newDevDepSinceLastSave || this.hasDevDepsInstalled() ? new UpdateDevJob(this.project) : new UpdateJob(this.project);
                job.setUser(false);
                job.schedule();
                this.newDepSinceLastSave = false;
                this.newDevDepSinceLastSave = false;
            }
            if (buildpath.booleanValue() && !update.booleanValue()) {
                this.buildPathManager.update();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean hasDevDepsInstalled() {
        if (this.composerPackage.getRequireDev().size() > 0) {
            VersionedPackage dev = this.composerPackage.getRequireDev().toArray()[0];
            ComposerPackages installed = this.composerProject.getInstalledPackages();
            return installed.has(dev.getName());
        }
        return false;
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void documentAboutToBeChanged(DocumentEvent event) {
    }

    private void documentChanged(DocumentEvent event) {
        String contents = event.getDocument().get();
        if (!this.pageChanging && !this.saving) {
            if (this.isJsonEditor()) {
                IDocument document = this.documentProvider.getDocument((Object)this.getEditorInput());
                if (document.get() != null && !document.get().equals(contents)) {
                    document.set(contents);
                }
            } else {
                this.parse(contents);
            }
            this.setDirty(false);
        }
        if (!this.saving && this.jsonDump != null && !this.jsonDump.equals(contents)) {
            this.setDirty(true);
        }
    }

    private boolean isJsonEditor() {
        return this.getActiveEditor() == this.jsonEditor;
    }

    private void parse(String contents) {
        try {
            this.composerPackage.fromJson(contents);
            this.setValidJson(true);
        }
        catch (ParseException e) {
            this.setValidJson(false, e);
        }
    }

    private void validateJson(String contents) {
        try {
            new ComposerPackage(contents);
            this.setValidJson(true);
        }
        catch (ParseException e) {
            this.setValidJson(false, e);
        }
    }

    private void setValidJson(boolean valid) {
        this.setValidJson(valid, null);
    }

    private void setValidJson(boolean valid, ParseException e) {
        this.validJson = valid;
        if (valid) {
            this.removeMessage(MSG_PARSE_ERROR);
        } else {
            this.addMessage(MSG_PARSE_ERROR, "Invalid Json: " + e.getMessage(), 3);
        }
        if (this.pages != null) {
            for (Object pageObj : this.pages) {
                if (!(pageObj instanceof ComposerFormPage) || pageObj == this.jsonEditor) continue;
                ComposerFormPage page = (ComposerFormPage)((Object)pageObj);
                page.setEnabled(valid);
            }
        }
    }

    public boolean isValidJson() {
        return this.validJson;
    }

    private void addMessage(String id, String message, int type) {
        this.addMessage(id, message, type, null);
    }

    private void addMessage(String id, String message, int type, Object data) {
        IManagedForm headerForm = this.getHeaderForm();
        if (headerForm != null) {
            headerForm.getMessageManager().addMessage((Object)id, message, data, type);
        }
    }

    private void removeMessage(String id) {
        IManagedForm headerForm = this.getHeaderForm();
        if (headerForm != null) {
            headerForm.getMessageManager().removeMessage((Object)id);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean value) {
        this.dirty = value;
        this.editorDirtyStateChanged();
    }

    public IProject getProject() {
        return this.project;
    }

    public ComposerPackage getComposerPackge() {
        return this.composerPackage;
    }

    private void resourceChanged(IResourceChangeEvent event) {
        if (this.jsonFile == null) {
            return;
        }
        if (event.getType() == 2 || event.getType() == 4) {
            if (this.jsonFile.getProject().equals((Object)event.getResource())) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ComposerFormEditor.this.close(false);
                    }
                });
            }
            return;
        }
        try {
            class RemovedResourceDeltaVisitor
            implements IResourceDeltaVisitor {
                boolean removed = false;

                RemovedResourceDeltaVisitor() {
                }

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getResource() != null && delta.getResource().equals((Object)ComposerFormEditor.this.jsonFile) && (delta.getKind() & 2) != 0) {
                        this.removed = true;
                        return false;
                    }
                    return true;
                }
            }
            RemovedResourceDeltaVisitor visitor = new RemovedResourceDeltaVisitor();
            event.getDelta().accept((IResourceDeltaVisitor)visitor);
            if (visitor.removed) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ComposerFormEditor.this.close(true);
                    }
                });
            }
        }
        catch (CoreException ex) {
            Logger.logException((Throwable)ex);
        }
    }
}

