/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.editor.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.composer.api.collection.JsonArray;
import org.eclipse.php.composer.api.objects.Scripts;
import org.eclipse.php.composer.ui.controller.ScriptsController;
import org.eclipse.php.composer.ui.dialogs.ScriptDialog;
import org.eclipse.php.composer.ui.editor.ComposerFormPage;
import org.eclipse.php.composer.ui.editor.FormLayoutFactory;
import org.eclipse.php.composer.ui.editor.TreeSection;
import org.eclipse.php.composer.ui.parts.TreePart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ScriptsSection
extends TreeSection
implements PropertyChangeListener {
    private TreeViewer scriptsViewer;
    private IAction addAction;
    private IAction editAction;
    private IAction removeAction;
    private static final int ADD_INDEX = 0;
    private static final int EDIT_INDEX = 1;
    private static final int REMOVE_INDEX = 2;

    public ScriptsSection(ComposerFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{"Add...", "Edit...", "Remove"});
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText("Scripts");
        section.setDescription("Manage the scripts for your package.");
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gd);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 4, 2, toolkit);
        TreePart treePart = this.getTreePart();
        ScriptsController scriptsController = new ScriptsController();
        this.scriptsViewer = treePart.getTreeViewer();
        this.scriptsViewer.setContentProvider((IContentProvider)scriptsController);
        this.scriptsViewer.setLabelProvider((IBaseLabelProvider)scriptsController);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        this.scriptsViewer.setInput((Object)this.composerPackage.getScripts());
        this.composerPackage.addPropertyChangeListener((PropertyChangeListener)this);
        this.updateButtons();
        this.makeActions();
        this.updateMenu();
    }

    @Override
    protected boolean createCount() {
        return true;
    }

    private void updateButtons() {
        ISelection selection = this.scriptsViewer.getSelection();
        TreePart treePart = this.getTreePart();
        treePart.setButtonEnabled(0, this.enabled);
        treePart.setButtonEnabled(1, !selection.isEmpty() && this.enabled);
        treePart.setButtonEnabled(2, !selection.isEmpty() && this.enabled);
    }

    private void updateMenu() {
        IStructuredSelection selection = (IStructuredSelection)this.scriptsViewer.getSelection();
        this.editAction.setEnabled(selection.size() > 0);
        this.removeAction.setEnabled(selection.size() > 0);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateButtons();
        this.refresh();
        this.scriptsViewer.getTree().setEnabled(enabled);
    }

    public void refresh() {
        this.scriptsViewer.refresh();
        super.refresh();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().startsWith("scripts")) {
            this.refresh();
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection sel) {
        this.updateButtons();
        this.updateMenu();
    }

    private void makeActions() {
        this.addAction = new Action("Add..."){

            public void run() {
                ScriptsSection.this.handleAdd();
            }
        };
        this.editAction = new Action("Edit..."){

            public void run() {
                ScriptsSection.this.handleEdit();
            }
        };
        this.removeAction = new Action("Remove"){

            public void run() {
                ScriptsSection.this.handleRemove();
            }
        };
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add(this.addAction);
        manager.add(this.editAction);
        manager.add(this.removeAction);
    }

    private void handleAdd() {
        ScriptDialog diag = new ScriptDialog(this.scriptsViewer.getTree().getShell());
        if (!this.scriptsViewer.getSelection().isEmpty()) {
            Object element = ((StructuredSelection)this.scriptsViewer.getSelection()).getFirstElement();
            ScriptsController controller = (ScriptsController)this.scriptsViewer.getLabelProvider();
            String text = controller.getText(element);
            if (Arrays.asList(Scripts.getEvents()).contains(text)) {
                diag.setEvent(text);
            }
        }
        if (diag.open() == 0) {
            this.composerPackage.getScripts().getAsArray(diag.getEvent()).add((Object)diag.getHandler());
            this.refresh();
        }
    }

    private void handleEdit() {
        Object element = ((StructuredSelection)this.scriptsViewer.getSelection()).getFirstElement();
        ScriptsController controller = (ScriptsController)this.scriptsViewer.getLabelProvider();
        String text = controller.getText(element);
        ScriptDialog diag = new ScriptDialog(this.scriptsViewer.getTree().getShell());
        if (Arrays.asList(Scripts.getEvents()).contains(text)) {
            String event;
            diag.setEvent(text);
            diag.setHandlerEnabled(false);
            if (diag.open() == 0 && !(event = diag.getEvent()).equalsIgnoreCase(text)) {
                this.composerPackage.getScripts().set(event, (Object)this.composerPackage.getScripts().getAsArray(text));
                this.composerPackage.getScripts().remove(text);
            }
        } else {
            String handler;
            String event = controller.getText(controller.getParent(element));
            diag.setEvent(event);
            diag.setHandler(text);
            diag.setEventEnabled(false);
            if (diag.open() == 0 && !(handler = diag.getHandler()).equalsIgnoreCase(text)) {
                JsonArray events = this.composerPackage.getScripts().getAsArray(event);
                events.replace((Object)text, (Object)handler);
            }
        }
    }

    private void handleRemove() {
        Object element = ((StructuredSelection)this.scriptsViewer.getSelection()).getFirstElement();
        ScriptsController controller = (ScriptsController)this.scriptsViewer.getLabelProvider();
        String text = controller.getText(element);
        if (Arrays.asList(Scripts.getEvents()).contains(text)) {
            MessageDialog diag = new MessageDialog(this.scriptsViewer.getTree().getShell(), "Remove Event", null, "Do you really wan't to remove " + text + "?", 4, new String[]{"Yes", "No"}, 0);
            if (diag.open() == 0) {
                this.composerPackage.getScripts().remove(text);
            }
        } else {
            String event = controller.getText(controller.getParent(element));
            MessageDialog diag = new MessageDialog(this.scriptsViewer.getTree().getShell(), "Remove Event", null, "Do you really wan't to remove " + text + " in " + event + "?", 4, new String[]{"Yes", "No"}, 0);
            if (diag.open() == 0) {
                JsonArray events = this.composerPackage.getScripts().getAsArray(event);
                events.remove((Object)text);
            }
        }
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleEdit();
                break;
            }
            case 2: {
                this.handleRemove();
            }
        }
    }
}

