/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.editor.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.php.composer.api.objects.Support;
import org.eclipse.php.composer.ui.editor.ComposerFormPage;
import org.eclipse.php.composer.ui.editor.ComposerSection;
import org.eclipse.php.composer.ui.editor.FormEntryAdapter;
import org.eclipse.php.composer.ui.editor.FormLayoutFactory;
import org.eclipse.php.composer.ui.parts.FormEntry;
import org.eclipse.php.composer.ui.parts.WeblinkFormEntry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class SupportSection
extends ComposerSection {
    Support support;
    private FormEntry emailEntry;
    private FormEntry issuesEntry;
    private FormEntry forumEntry;
    private FormEntry wikiEntry;
    private FormEntry ircEntry;
    private FormEntry sourceEntry;

    public SupportSection(ComposerFormPage page, Composite parent) {
        super(page, parent, 128);
        this.support = this.composerPackage.getSupport();
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText("Support");
        section.setDescription("Provide support options to your end-users.");
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 2));
        section.setClient((Control)client);
        this.createEmailEntry(client, toolkit);
        this.createIssuesEntry(client, toolkit);
        this.createForumEntry(client, toolkit);
        this.createWikiEntry(client, toolkit);
        this.createIrcEntry(client, toolkit);
        this.createSourceEntry(client, toolkit);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.emailEntry.setEnabled(enabled);
        this.issuesEntry.setEnabled(enabled);
        this.forumEntry.setEnabled(enabled);
        this.wikiEntry.setEnabled(enabled);
        this.ircEntry.setEnabled(enabled);
        this.sourceEntry.setEnabled(enabled);
    }

    private void createEmailEntry(Composite client, FormToolkit toolkit) {
        this.emailEntry = new FormEntry(client, toolkit, "Email", null, false);
        this.emailEntry.setValue(this.support.getEmail(), true);
        this.emailEntry.addFormEntryListener(new FormEntryAdapter(){

            @Override
            public void textValueChanged(FormEntry entry) {
                SupportSection.this.support.setEmail(entry.getValue());
            }
        });
        this.support.addPropertyChangeListener("email", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SupportSection.this.emailEntry.setValue(SupportSection.this.support.getEmail(), true);
            }
        });
    }

    private void createIssuesEntry(Composite client, FormToolkit toolkit) {
        this.issuesEntry = new WeblinkFormEntry(client, toolkit, "Issues");
        this.issuesEntry.setValue(this.support.getIssues());
        this.issuesEntry.addFormEntryListener(new FormEntryAdapter(){

            @Override
            public void textValueChanged(FormEntry entry) {
                SupportSection.this.support.setIssues(entry.getValue());
            }
        });
        this.support.addPropertyChangeListener("issues", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SupportSection.this.issuesEntry.setValue(SupportSection.this.support.getIssues(), true);
            }
        });
    }

    private void createForumEntry(Composite client, FormToolkit toolkit) {
        this.forumEntry = new WeblinkFormEntry(client, toolkit, "Forum");
        this.forumEntry.setValue(this.support.getForum());
        this.forumEntry.addFormEntryListener(new FormEntryAdapter(){

            @Override
            public void textValueChanged(FormEntry entry) {
                SupportSection.this.support.setForum(entry.getValue());
            }
        });
        this.support.addPropertyChangeListener("forum", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SupportSection.this.forumEntry.setValue(SupportSection.this.support.getForum(), true);
            }
        });
    }

    private void createWikiEntry(Composite client, FormToolkit toolkit) {
        this.wikiEntry = new WeblinkFormEntry(client, toolkit, "Wiki");
        this.wikiEntry.setValue(this.support.getWiki());
        this.wikiEntry.addFormEntryListener(new FormEntryAdapter(){

            @Override
            public void textValueChanged(FormEntry entry) {
                SupportSection.this.support.setWiki(entry.getValue());
            }
        });
        this.support.addPropertyChangeListener("wiki", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SupportSection.this.wikiEntry.setValue(SupportSection.this.support.getWiki(), true);
            }
        });
    }

    private void createIrcEntry(Composite client, FormToolkit toolkit) {
        this.ircEntry = new WeblinkFormEntry(client, toolkit, "Irc");
        this.ircEntry.setValue(this.support.getIrc());
        this.ircEntry.addFormEntryListener(new FormEntryAdapter(){

            @Override
            public void textValueChanged(FormEntry entry) {
                SupportSection.this.support.setIrc(entry.getValue());
            }
        });
        this.support.addPropertyChangeListener("irc", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SupportSection.this.ircEntry.setValue(SupportSection.this.support.getIrc(), true);
            }
        });
    }

    private void createSourceEntry(Composite client, FormToolkit toolkit) {
        this.sourceEntry = new WeblinkFormEntry(client, toolkit, "Source");
        this.sourceEntry.setValue(this.support.getSource());
        this.sourceEntry.addFormEntryListener(new FormEntryAdapter(){

            @Override
            public void textValueChanged(FormEntry entry) {
                SupportSection.this.support.setSource(entry.getValue());
            }
        });
        this.support.addPropertyChangeListener("source", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SupportSection.this.sourceEntry.setValue(SupportSection.this.support.getSource(), true);
            }
        });
    }
}

