/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.job;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.composer.api.packages.PharDownloader;
import org.eclipse.php.composer.core.launch.ScriptLauncher;
import org.eclipse.php.composer.core.launch.execution.ExecutionResponseListener;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.ui.job.ComposerJob;

public class CreateProjectJob
extends ComposerJob {
    private final String projectName;
    private final String packageName;
    private IPath composerPath;
    private IPath path;
    private JobListener initListener;
    private String packageVersion;
    private boolean startNotified = false;
    private boolean existed;
    private File composerFile;

    public CreateProjectJob(IPath path, String projectName, String packageName, String packageVersion) {
        super("Creating composer project");
        this.projectName = projectName;
        this.packageName = packageName;
        this.packageVersion = packageVersion;
        this.path = path;
        Logger.debug((String)("Creating new project " + projectName + " from package " + packageName + " / " + packageVersion));
        ResourcesPlugin.getWorkspace();
        DummyProject project = new DummyProject(path);
        this.setProject((IProject)project);
        try {
            this.composerPath = path.append("composer.phar");
            this.composerFile = this.composerPath.toFile();
            this.existed = true;
            if (!this.composerFile.exists()) {
                this.existed = false;
                PharDownloader downloader = new PharDownloader();
                InputStream resource = downloader.download();
                FileUtils.copyInputStreamToFile((InputStream)resource, (File)this.composerFile);
            }
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
    }

    @Override
    protected void launch(ScriptLauncher launcher) throws ExecuteException, IOException, InterruptedException {
        launcher.setTimeout(300000);
        launcher.addResponseListener(new ExecutionResponseListener(){

            public void executionStarted() {
            }

            public void executionMessage(String message) {
                try {
                    if (CreateProjectJob.this.composerExists()) {
                        CreateProjectJob.this.notifyOnStart();
                    }
                }
                catch (Exception e) {
                    Logger.logException((Throwable)e);
                }
            }

            public void executionFinished(String response, int exitValue) {
                CreateProjectJob.this.notifyOnFinish();
            }

            public void executionFailed(String response, Exception exception) {
                CreateProjectJob.this.notifyOnFail();
            }

            public void executionError(String message) {
                CreateProjectJob.this.notifyOnFail();
            }

            public void executionAboutToStart() {
            }
        });
        launcher.launch("create-project", new String[]{"--no-interaction", this.packageName, this.projectName, this.packageVersion});
    }

    private boolean composerExists() {
        IPath projectPath = this.path.append(this.projectName).append("composer.json");
        return projectPath.toFile().exists();
    }

    public void setJobListener(JobListener latch) {
        this.initListener = latch;
    }

    private void notifyOnStart() {
        try {
            if (this.startNotified || this.initListener == null) {
                return;
            }
            this.initListener.jobStarted();
            this.startNotified = true;
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
    }

    private void notifyOnFinish() {
        try {
            if (this.initListener == null) {
                return;
            }
            this.initListener.jobFinished(this.projectName);
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
    }

    private void notifyOnFail() {
        try {
            if (this.initListener == null) {
                return;
            }
            this.initListener.jobFailed();
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
    }

    protected void cleanup() {
        if (!this.existed && this.composerFile != null) {
            this.composerFile.delete();
        }
    }

    protected class DummyProject
    extends Project {
        public DummyProject(IPath path) {
            this(path, (Workspace)ResourcesPlugin.getWorkspace());
        }

        protected DummyProject(IPath path, Workspace container) {
            super(path, container);
        }

        public IResource findMember(String path) {
            return new DummyResource();
        }

        public IPath getLocation() {
            return CreateProjectJob.this.path;
        }
    }

    public class DummyResource
    extends org.eclipse.core.internal.resources.File {
        protected DummyResource() {
            super((IPath)new Path("/"), null);
        }

        public IPath getFullPath() {
            return new Path("/dummy/composer.phar");
        }
    }

    public static interface JobListener {
        public void jobStarted();

        public void jobFinished(String var1);

        public void jobFailed();
    }
}

