/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.job;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.php.composer.api.packages.PharDownloader;
import org.eclipse.php.composer.core.log.Logger;

public class DownloadJob
extends Job {
    private IProject project;
    private PharDownloader downloader;
    private IProgressMonitor monitor;

    public DownloadJob(IProject project) {
        super("Downloading composer.phar");
        this.project = project;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            try {
                this.monitor = monitor;
                monitor.beginTask("Downloading composer.phar from getcomposer.org", 3);
                this.downloader = new PharDownloader();
                InputStream resource = this.downloader.download();
                monitor.worked(1);
                IFile file = this.project.getFile("composer.phar");
                monitor.worked(1);
                file.create(resource, true, (IProgressMonitor)new NullProgressMonitor());
                file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                monitor.worked(1);
            }
            catch (Exception e) {
                Logger.logException((Throwable)e);
                Status status = new Status(4, "org.eclipse.php.composer.core", "Error while downloading composer.phar. See {workspace}/.metadata/.log for details");
                monitor.done();
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    protected void canceling() {
        super.canceling();
        if (this.monitor != null && this.monitor.isCanceled() && this.downloader != null) {
            this.downloader.abort();
        }
    }
}

