/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.wizard;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.php.composer.ui.wizard.AbstractWizardFirstPage;
import org.eclipse.php.composer.ui.wizard.ValidationException;

public abstract class AbstractValidator
implements Observer {
    protected AbstractWizardFirstPage firstPage;
    protected IWorkspace workspace;
    protected String name;
    protected IProject handle;
    protected String location;
    protected IEnvironment environment;

    public AbstractValidator(AbstractWizardFirstPage composerProjectWizardFirstPage) {
        this.firstPage = composerProjectWizardFirstPage;
    }

    @Override
    public void update(Observable observable, Object object) {
        this.workspace = DLTKUIPlugin.getWorkspace();
        this.name = this.firstPage.nameGroup.getName();
        if (this.name != null && this.name.length() > 0) {
            this.handle = this.firstPage.getProjectHandle();
        }
        if (this.firstPage.PHPLocationGroup != null) {
            this.location = this.firstPage.PHPLocationGroup.getLocation().toOSString();
        }
        this.environment = this.firstPage.getEnvironment();
        try {
            this.validateName();
            this.beginValidation();
            this.validateProjectNotExists();
            this.validateLocation();
            this.finishValidation();
        }
        catch (ValidationException e) {
            switch (e.getSeverity()) {
                case WARNING: {
                    this.firstPage.setErrorMessage(null);
                    this.firstPage.setMessage(e.getMessage());
                    break;
                }
                case ERROR: {
                    this.firstPage.setErrorMessage(e.getMessage());
                    this.firstPage.setMessage(null);
                    break;
                }
                default: {
                    return;
                }
            }
            this.firstPage.setPageComplete(false);
            return;
        }
        this.firstPage.setPageComplete(true);
        this.firstPage.setErrorMessage(null);
        this.firstPage.setMessage(null);
    }

    protected void validateName() throws ValidationException {
        if (this.name == null || this.name.length() == 0) {
            throw new ValidationException(NewWizardMessages.ScriptProjectWizardFirstPage_Message_enterProjectName, ValidationException.Severity.WARNING);
        }
        IStatus nameStatus = this.workspace.validateName(this.name, 4);
        if (!nameStatus.isOK()) {
            throw new ValidationException(nameStatus.getMessage(), ValidationException.Severity.ERROR);
        }
    }

    protected void validateProjectNotExists() throws ValidationException {
        if (!this.firstPage.isInLocalServer() && this.handle.exists()) {
            throw new ValidationException(NewWizardMessages.ScriptProjectWizardFirstPage_Message_projectAlreadyExists, ValidationException.Severity.ERROR);
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        String newProjectNameLowerCase = this.name.toLowerCase();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject currentProject = iProjectArray[n2];
            String existingProjectName = currentProject.getName();
            if (existingProjectName.toLowerCase().equals(newProjectNameLowerCase)) {
                throw new ValidationException(NewWizardMessages.ScriptProjectWizardFirstPage_Message_projectAlreadyExists, ValidationException.Severity.ERROR);
            }
            ++n2;
        }
    }

    protected void validateLocation() throws ValidationException {
        if (this.location.length() == 0) {
            throw new ValidationException(NewWizardMessages.ScriptProjectWizardFirstPage_Message_enterLocation, ValidationException.Severity.WARNING);
        }
        if (!Path.EMPTY.isValidPath(this.location)) {
            throw new ValidationException(NewWizardMessages.ScriptProjectWizardFirstPage_Message_invalidDirectory, ValidationException.Severity.ERROR);
        }
        IPath projectPath = Path.fromOSString((String)this.location);
        if (!this.firstPage.PHPLocationGroup.isInWorkspace() && Platform.getLocation().isPrefixOf(projectPath)) {
            throw new ValidationException(NewWizardMessages.ScriptProjectWizardFirstPage_Message_cannotCreateInWorkspace, ValidationException.Severity.ERROR);
        }
        if (!this.firstPage.PHPLocationGroup.isInWorkspace() && EnvironmentManager.isLocal((IEnvironment)this.environment)) {
            IStatus locationStatus = this.workspace.validateProjectLocation(this.handle, projectPath);
            if (!locationStatus.isOK()) {
                throw new ValidationException(locationStatus.getMessage(), ValidationException.Severity.ERROR);
            }
            if (!this.firstPage.canCreate(projectPath.toFile())) {
                throw new ValidationException(NewWizardMessages.ScriptProjectWizardFirstPage_Message_invalidDirectory, ValidationException.Severity.ERROR);
            }
        }
    }

    protected abstract void beginValidation() throws ValidationException;

    protected abstract void finishValidation() throws ValidationException;
}

