/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests;

import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.TestUtils;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public class PDTTUtils {
    public static String[] getPDTTFiles(String testsDirectory) {
        return PDTTUtils.getPDTTFiles(testsDirectory, PHPCoreTests.getDefault().getBundle());
    }

    public static String[] getPDTTFiles(String testsDirectory, Bundle bundle) {
        return PDTTUtils.getFiles(testsDirectory, bundle, ".pdtt");
    }

    public static String[] getFiles(String testsDirectory, String ext) {
        return PDTTUtils.getFiles(testsDirectory, PHPCoreTests.getDefault().getBundle(), ext);
    }

    public static String[] getFiles(String testsDirectory, Bundle bundle, String ext) {
        LinkedList<String> files = new LinkedList<String>();
        Enumeration entryPaths = bundle.getEntryPaths(testsDirectory);
        if (entryPaths != null) {
            while (entryPaths.hasMoreElements()) {
                String name;
                String path = (String)entryPaths.nextElement();
                URL entry = bundle.getEntry(path);
                try {
                    entry.openStream().close();
                }
                catch (Exception exception) {
                    continue;
                }
                int pos = path.lastIndexOf(47);
                String string = name = pos >= 0 ? path.substring(pos + 1) : path;
                if (!name.endsWith(ext)) continue;
                files.add(path);
            }
        }
        Collections.sort(files);
        return files.toArray(new String[files.size()]);
    }

    public static void assertContents(String expected, String actual) {
        String diff = TestUtils.compareContents(expected, actual);
        if (diff != null) {
            Assert.fail((String)diff);
        }
    }
}

